/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DeviceType;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.RumResourceMethod;
import com.datadog.android.rum.internal.RumErrorSourceType;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u0084\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004H\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0004H\u0000\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0004H\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0004H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0004H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\rH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\rH\u0000\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0014H\u0000\u001a\f\u0010\u001f\u001a\u00020 *\u00020\u0017H\u0000\u001a\f\u0010!\u001a\u00020\"*\u00020\rH\u0000\u001a\f\u0010#\u001a\u00020$*\u00020\u0014H\u0000\u001a\f\u0010%\u001a\u00020&*\u00020\u0017H\u0000\u001a\u0016\u0010'\u001a\u0004\u0018\u00010(*\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0000\u001a\f\u0010+\u001a\u00020,*\u00020\rH\u0000\u001a\f\u0010-\u001a\u00020.*\u00020\u001cH\u0000\u001a\f\u0010/\u001a\u000200*\u00020\u0014H\u0000\u001a\f\u00101\u001a\u000202*\u00020\u0017H\u0000\u001a\f\u00103\u001a\u000204*\u000205H\u0000\u001a\f\u00106\u001a\u000207*\u000208H\u0000\u001a\f\u00109\u001a\u00020:*\u00020;H\u0000\u001a\f\u00109\u001a\u00020<*\u00020=H\u0000\u001a\f\u0010>\u001a\u00020?*\u00020\rH\u0000\u001a\f\u0010@\u001a\u00020A*\u00020\u0014H\u0000\u001a\f\u0010B\u001a\u00020C*\u00020\u0017H\u0000\u001a\u001e\u0010D\u001a\u0004\u0018\u00010E*\u00020F2\u0006\u0010G\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0000\u001a\u001e\u0010D\u001a\u0004\u0018\u00010H*\u00020I2\u0006\u0010G\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0000\u001a\u001e\u0010D\u001a\u0004\u0018\u00010J*\u00020K2\u0006\u0010G\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0000\u001a\u001e\u0010D\u001a\u0004\u0018\u00010L*\u00020M2\u0006\u0010G\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0000\u001a\u001e\u0010D\u001a\u0004\u0018\u00010N*\u00020O2\u0006\u0010G\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT", "", "connect", "Lcom/datadog/android/rum/model/ResourceEvent$Connect;", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "dns", "Lcom/datadog/android/rum/model/ResourceEvent$Dns;", "download", "Lcom/datadog/android/rum/model/ResourceEvent$Download;", "firstByte", "Lcom/datadog/android/rum/model/ResourceEvent$FirstByte;", "isConnected", "", "Lcom/datadog/android/api/context/NetworkInfo;", "ssl", "Lcom/datadog/android/rum/model/ResourceEvent$Ssl;", "toActionConnectivity", "Lcom/datadog/android/rum/model/ActionEvent$Connectivity;", "toActionSchemaType", "Lcom/datadog/android/rum/model/ActionEvent$DeviceType;", "Lcom/datadog/android/api/context/DeviceType;", "toActionSessionPrecondition", "Lcom/datadog/android/rum/model/ActionEvent$SessionPrecondition;", "Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$StartReason;", "toErrorConnectivity", "Lcom/datadog/android/rum/model/ErrorEvent$Connectivity;", "toErrorMethod", "Lcom/datadog/android/rum/model/ErrorEvent$Method;", "Lcom/datadog/android/rum/RumResourceMethod;", "toErrorSchemaType", "Lcom/datadog/android/rum/model/ErrorEvent$DeviceType;", "toErrorSessionPrecondition", "Lcom/datadog/android/rum/model/ErrorEvent$SessionPrecondition;", "toLongTaskConnectivity", "Lcom/datadog/android/rum/model/LongTaskEvent$Connectivity;", "toLongTaskSchemaType", "Lcom/datadog/android/rum/model/LongTaskEvent$DeviceType;", "toLongTaskSessionPrecondition", "Lcom/datadog/android/rum/model/LongTaskEvent$SessionPrecondition;", "toOperationType", "Lcom/datadog/android/rum/model/ResourceEvent$OperationType;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "toResourceConnectivity", "Lcom/datadog/android/rum/model/ResourceEvent$Connectivity;", "toResourceMethod", "Lcom/datadog/android/rum/model/ResourceEvent$Method;", "toResourceSchemaType", "Lcom/datadog/android/rum/model/ResourceEvent$DeviceType;", "toResourceSessionPrecondition", "Lcom/datadog/android/rum/model/ResourceEvent$SessionPrecondition;", "toSchemaSource", "Lcom/datadog/android/rum/model/ErrorEvent$ErrorSource;", "Lcom/datadog/android/rum/RumErrorSource;", "toSchemaSourceType", "Lcom/datadog/android/rum/model/ErrorEvent$SourceType;", "Lcom/datadog/android/rum/internal/RumErrorSourceType;", "toSchemaType", "Lcom/datadog/android/rum/model/ActionEvent$ActionEventActionType;", "Lcom/datadog/android/rum/RumActionType;", "Lcom/datadog/android/rum/model/ResourceEvent$ResourceType;", "Lcom/datadog/android/rum/RumResourceKind;", "toViewConnectivity", "Lcom/datadog/android/rum/model/ViewEvent$Connectivity;", "toViewSchemaType", "Lcom/datadog/android/rum/model/ViewEvent$DeviceType;", "toViewSessionPrecondition", "Lcom/datadog/android/rum/model/ViewEvent$SessionPrecondition;", "tryFromSource", "Lcom/datadog/android/rum/model/ActionEvent$ActionEventSource;", "Lcom/datadog/android/rum/model/ActionEvent$ActionEventSource$Companion;", "source", "Lcom/datadog/android/rum/model/ErrorEvent$ErrorEventSource;", "Lcom/datadog/android/rum/model/ErrorEvent$ErrorEventSource$Companion;", "Lcom/datadog/android/rum/model/LongTaskEvent$LongTaskEventSource;", "Lcom/datadog/android/rum/model/LongTaskEvent$LongTaskEventSource$Companion;", "Lcom/datadog/android/rum/model/ResourceEvent$ResourceEventSource;", "Lcom/datadog/android/rum/model/ResourceEvent$ResourceEventSource$Companion;", "Lcom/datadog/android/rum/model/ViewEvent$ViewEventSource;", "Lcom/datadog/android/rum/model/ViewEvent$ViewEventSource$Companion;", "dd-sdk-android-rum_release"})
public final class RumEventExtKt {
    @NotNull
    public static final String UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT = "You are using an unknown source %s for your events";

    @NotNull
    public static final ResourceEvent.Method toResourceMethod(@NotNull RumResourceMethod $this$toResourceMethod) {
        ResourceEvent.Method method;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toResourceMethod), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toResourceMethod.ordinal()]) {
            case 1: {
                method = ResourceEvent.Method.GET;
                break;
            }
            case 2: {
                method = ResourceEvent.Method.POST;
                break;
            }
            case 3: {
                method = ResourceEvent.Method.HEAD;
                break;
            }
            case 4: {
                method = ResourceEvent.Method.PUT;
                break;
            }
            case 5: {
                method = ResourceEvent.Method.DELETE;
                break;
            }
            case 6: {
                method = ResourceEvent.Method.PATCH;
                break;
            }
            case 7: {
                method = ResourceEvent.Method.TRACE;
                break;
            }
            case 8: {
                method = ResourceEvent.Method.OPTIONS;
                break;
            }
            case 9: {
                method = ResourceEvent.Method.CONNECT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return method;
    }

    @NotNull
    public static final ErrorEvent.Method toErrorMethod(@NotNull RumResourceMethod $this$toErrorMethod) {
        ErrorEvent.Method method;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toErrorMethod), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toErrorMethod.ordinal()]) {
            case 1: {
                method = ErrorEvent.Method.GET;
                break;
            }
            case 2: {
                method = ErrorEvent.Method.POST;
                break;
            }
            case 3: {
                method = ErrorEvent.Method.HEAD;
                break;
            }
            case 4: {
                method = ErrorEvent.Method.PUT;
                break;
            }
            case 5: {
                method = ErrorEvent.Method.DELETE;
                break;
            }
            case 6: {
                method = ErrorEvent.Method.PATCH;
                break;
            }
            case 7: {
                method = ErrorEvent.Method.TRACE;
                break;
            }
            case 8: {
                method = ErrorEvent.Method.OPTIONS;
                break;
            }
            case 9: {
                method = ErrorEvent.Method.CONNECT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return method;
    }

    @Nullable
    public static final ResourceEvent.OperationType toOperationType(@NotNull String $this$toOperationType, @NotNull InternalLogger internalLogger) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toOperationType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            object = $this$toOperationType;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = object.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(locale)");
            object = ResourceEvent.OperationType.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>($this$toOperationType){
                final /* synthetic */ String $this_toOperationType;
                {
                    this.$this_toOperationType = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unable to convert [" + this.$this_toOperationType + "] to a valid graphql operation type";
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            object = null;
        }
        return object;
    }

    @NotNull
    public static final ResourceEvent.ResourceType toSchemaType(@NotNull RumResourceKind $this$toSchemaType) {
        ResourceEvent.ResourceType resourceType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toSchemaType.ordinal()]) {
            case 1: {
                resourceType = ResourceEvent.ResourceType.BEACON;
                break;
            }
            case 2: {
                resourceType = ResourceEvent.ResourceType.FETCH;
                break;
            }
            case 3: {
                resourceType = ResourceEvent.ResourceType.XHR;
                break;
            }
            case 4: {
                resourceType = ResourceEvent.ResourceType.DOCUMENT;
                break;
            }
            case 5: {
                resourceType = ResourceEvent.ResourceType.IMAGE;
                break;
            }
            case 6: {
                resourceType = ResourceEvent.ResourceType.JS;
                break;
            }
            case 7: {
                resourceType = ResourceEvent.ResourceType.FONT;
                break;
            }
            case 8: {
                resourceType = ResourceEvent.ResourceType.CSS;
                break;
            }
            case 9: {
                resourceType = ResourceEvent.ResourceType.MEDIA;
                break;
            }
            case 10: {
                resourceType = ResourceEvent.ResourceType.NATIVE;
                break;
            }
            case 11: 
            case 12: {
                resourceType = ResourceEvent.ResourceType.OTHER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resourceType;
    }

    @NotNull
    public static final ErrorEvent.ErrorSource toSchemaSource(@NotNull RumErrorSource $this$toSchemaSource) {
        ErrorEvent.ErrorSource errorSource;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaSource), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toSchemaSource.ordinal()]) {
            case 1: {
                errorSource = ErrorEvent.ErrorSource.NETWORK;
                break;
            }
            case 2: {
                errorSource = ErrorEvent.ErrorSource.SOURCE;
                break;
            }
            case 3: {
                errorSource = ErrorEvent.ErrorSource.CONSOLE;
                break;
            }
            case 4: {
                errorSource = ErrorEvent.ErrorSource.LOGGER;
                break;
            }
            case 5: {
                errorSource = ErrorEvent.ErrorSource.AGENT;
                break;
            }
            case 6: {
                errorSource = ErrorEvent.ErrorSource.WEBVIEW;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return errorSource;
    }

    @NotNull
    public static final ErrorEvent.SourceType toSchemaSourceType(@NotNull RumErrorSourceType $this$toSchemaSourceType) {
        ErrorEvent.SourceType sourceType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaSourceType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$3[$this$toSchemaSourceType.ordinal()]) {
            case 1: {
                sourceType = ErrorEvent.SourceType.ANDROID;
                break;
            }
            case 2: {
                sourceType = ErrorEvent.SourceType.BROWSER;
                break;
            }
            case 3: {
                sourceType = ErrorEvent.SourceType.REACT_NATIVE;
                break;
            }
            case 4: {
                sourceType = ErrorEvent.SourceType.FLUTTER;
                break;
            }
            case 5: {
                sourceType = ErrorEvent.SourceType.NDK;
                break;
            }
            case 6: {
                sourceType = ErrorEvent.SourceType.NDK_IL2CPP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sourceType;
    }

    @Nullable
    public static final ResourceEvent.Dns dns(@NotNull ResourceTiming $this$dns) {
        Intrinsics.checkNotNullParameter((Object)$this$dns, (String)"<this>");
        return $this$dns.getDnsStart() > 0L ? new ResourceEvent.Dns($this$dns.getDnsDuration(), $this$dns.getDnsStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.Connect connect(@NotNull ResourceTiming $this$connect) {
        Intrinsics.checkNotNullParameter((Object)$this$connect, (String)"<this>");
        return $this$connect.getConnectStart() > 0L ? new ResourceEvent.Connect($this$connect.getConnectDuration(), $this$connect.getConnectStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.Ssl ssl(@NotNull ResourceTiming $this$ssl) {
        Intrinsics.checkNotNullParameter((Object)$this$ssl, (String)"<this>");
        return $this$ssl.getSslStart() > 0L ? new ResourceEvent.Ssl($this$ssl.getSslDuration(), $this$ssl.getSslStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.FirstByte firstByte(@NotNull ResourceTiming $this$firstByte) {
        Intrinsics.checkNotNullParameter((Object)$this$firstByte, (String)"<this>");
        return $this$firstByte.getFirstByteStart() >= 0L && $this$firstByte.getFirstByteDuration() > 0L ? new ResourceEvent.FirstByte($this$firstByte.getFirstByteDuration(), $this$firstByte.getFirstByteStart()) : null;
    }

    @Nullable
    public static final ResourceEvent.Download download(@NotNull ResourceTiming $this$download) {
        Intrinsics.checkNotNullParameter((Object)$this$download, (String)"<this>");
        return $this$download.getDownloadStart() > 0L ? new ResourceEvent.Download($this$download.getDownloadDuration(), $this$download.getDownloadStart()) : null;
    }

    @NotNull
    public static final ActionEvent.ActionEventActionType toSchemaType(@NotNull RumActionType $this$toSchemaType) {
        ActionEvent.ActionEventActionType actionEventActionType;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSchemaType), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$4[$this$toSchemaType.ordinal()]) {
            case 1: {
                actionEventActionType = ActionEvent.ActionEventActionType.TAP;
                break;
            }
            case 2: {
                actionEventActionType = ActionEvent.ActionEventActionType.SCROLL;
                break;
            }
            case 3: {
                actionEventActionType = ActionEvent.ActionEventActionType.SWIPE;
                break;
            }
            case 4: {
                actionEventActionType = ActionEvent.ActionEventActionType.CLICK;
                break;
            }
            case 5: {
                actionEventActionType = ActionEvent.ActionEventActionType.BACK;
                break;
            }
            case 6: {
                actionEventActionType = ActionEvent.ActionEventActionType.CUSTOM;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return actionEventActionType;
    }

    @NotNull
    public static final ResourceEvent.Connectivity toResourceConnectivity(@NotNull NetworkInfo $this$toResourceConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toResourceConnectivity, (String)"<this>");
        ResourceEvent.Status status = RumEventExtKt.isConnected($this$toResourceConnectivity) ? ResourceEvent.Status.CONNECTED : ResourceEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toResourceConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ResourceEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ResourceEvent.Cellular cellular = $this$toResourceConnectivity.getCellularTechnology() != null || $this$toResourceConnectivity.getCarrierName() != null ? new ResourceEvent.Cellular($this$toResourceConnectivity.getCellularTechnology(), $this$toResourceConnectivity.getCarrierName()) : null;
        return new ResourceEvent.Connectivity(status, interfaces, null, cellular, 4, null);
    }

    @NotNull
    public static final ErrorEvent.Connectivity toErrorConnectivity(@NotNull NetworkInfo $this$toErrorConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toErrorConnectivity, (String)"<this>");
        ErrorEvent.Status status = RumEventExtKt.isConnected($this$toErrorConnectivity) ? ErrorEvent.Status.CONNECTED : ErrorEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toErrorConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ErrorEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ErrorEvent.Cellular cellular = $this$toErrorConnectivity.getCellularTechnology() != null || $this$toErrorConnectivity.getCarrierName() != null ? new ErrorEvent.Cellular($this$toErrorConnectivity.getCellularTechnology(), $this$toErrorConnectivity.getCarrierName()) : null;
        return new ErrorEvent.Connectivity(status, interfaces, null, cellular, 4, null);
    }

    @NotNull
    public static final LongTaskEvent.Connectivity toLongTaskConnectivity(@NotNull NetworkInfo $this$toLongTaskConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toLongTaskConnectivity, (String)"<this>");
        LongTaskEvent.Status status = RumEventExtKt.isConnected($this$toLongTaskConnectivity) ? LongTaskEvent.Status.CONNECTED : LongTaskEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toLongTaskConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)LongTaskEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        LongTaskEvent.Cellular cellular = $this$toLongTaskConnectivity.getCellularTechnology() != null || $this$toLongTaskConnectivity.getCarrierName() != null ? new LongTaskEvent.Cellular($this$toLongTaskConnectivity.getCellularTechnology(), $this$toLongTaskConnectivity.getCarrierName()) : null;
        return new LongTaskEvent.Connectivity(status, interfaces, null, cellular, 4, null);
    }

    @NotNull
    public static final ViewEvent.Connectivity toViewConnectivity(@NotNull NetworkInfo $this$toViewConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toViewConnectivity, (String)"<this>");
        ViewEvent.Status status = RumEventExtKt.isConnected($this$toViewConnectivity) ? ViewEvent.Status.CONNECTED : ViewEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toViewConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ViewEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ViewEvent.Cellular cellular = $this$toViewConnectivity.getCellularTechnology() != null || $this$toViewConnectivity.getCarrierName() != null ? new ViewEvent.Cellular($this$toViewConnectivity.getCellularTechnology(), $this$toViewConnectivity.getCarrierName()) : null;
        return new ViewEvent.Connectivity(status, interfaces, null, cellular, 4, null);
    }

    @NotNull
    public static final ActionEvent.Connectivity toActionConnectivity(@NotNull NetworkInfo $this$toActionConnectivity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toActionConnectivity, (String)"<this>");
        ActionEvent.Status status = RumEventExtKt.isConnected($this$toActionConnectivity) ? ActionEvent.Status.CONNECTED : ActionEvent.Status.NOT_CONNECTED;
        switch (WhenMappings.$EnumSwitchMapping$5[$this$toActionConnectivity.getConnectivity().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.ETHERNET));
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.WIFI));
                break;
            }
            case 3: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.WIMAX));
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.BLUETOOTH));
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.CELLULAR));
                break;
            }
            case 11: {
                list = CollectionsKt.listOf((Object)((Object)ActionEvent.Interface.OTHER));
                break;
            }
            case 12: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List interfaces = list;
        ActionEvent.Cellular cellular = $this$toActionConnectivity.getCellularTechnology() != null || $this$toActionConnectivity.getCarrierName() != null ? new ActionEvent.Cellular($this$toActionConnectivity.getCellularTechnology(), $this$toActionConnectivity.getCarrierName()) : null;
        return new ActionEvent.Connectivity(status, interfaces, null, cellular, 4, null);
    }

    public static final boolean isConnected(@NotNull NetworkInfo $this$isConnected) {
        Intrinsics.checkNotNullParameter((Object)$this$isConnected, (String)"<this>");
        return $this$isConnected.getConnectivity() != NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
    }

    @NotNull
    public static final ViewEvent.DeviceType toViewSchemaType(@NotNull DeviceType $this$toViewSchemaType) {
        ViewEvent.DeviceType deviceType;
        Intrinsics.checkNotNullParameter((Object)$this$toViewSchemaType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$6[$this$toViewSchemaType.ordinal()]) {
            case 1: {
                deviceType = ViewEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType = ViewEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType = ViewEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType = ViewEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType = ViewEvent.DeviceType.OTHER;
            }
        }
        return deviceType;
    }

    @NotNull
    public static final ActionEvent.DeviceType toActionSchemaType(@NotNull DeviceType $this$toActionSchemaType) {
        ActionEvent.DeviceType deviceType;
        Intrinsics.checkNotNullParameter((Object)$this$toActionSchemaType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$6[$this$toActionSchemaType.ordinal()]) {
            case 1: {
                deviceType = ActionEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType = ActionEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType = ActionEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType = ActionEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType = ActionEvent.DeviceType.OTHER;
            }
        }
        return deviceType;
    }

    @NotNull
    public static final LongTaskEvent.DeviceType toLongTaskSchemaType(@NotNull DeviceType $this$toLongTaskSchemaType) {
        LongTaskEvent.DeviceType deviceType;
        Intrinsics.checkNotNullParameter((Object)$this$toLongTaskSchemaType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$6[$this$toLongTaskSchemaType.ordinal()]) {
            case 1: {
                deviceType = LongTaskEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType = LongTaskEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType = LongTaskEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType = LongTaskEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType = LongTaskEvent.DeviceType.OTHER;
            }
        }
        return deviceType;
    }

    @NotNull
    public static final ResourceEvent.DeviceType toResourceSchemaType(@NotNull DeviceType $this$toResourceSchemaType) {
        ResourceEvent.DeviceType deviceType;
        Intrinsics.checkNotNullParameter((Object)$this$toResourceSchemaType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$6[$this$toResourceSchemaType.ordinal()]) {
            case 1: {
                deviceType = ResourceEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType = ResourceEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType = ResourceEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType = ResourceEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType = ResourceEvent.DeviceType.OTHER;
            }
        }
        return deviceType;
    }

    @NotNull
    public static final ErrorEvent.DeviceType toErrorSchemaType(@NotNull DeviceType $this$toErrorSchemaType) {
        ErrorEvent.DeviceType deviceType;
        Intrinsics.checkNotNullParameter((Object)$this$toErrorSchemaType, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$6[$this$toErrorSchemaType.ordinal()]) {
            case 1: {
                deviceType = ErrorEvent.DeviceType.MOBILE;
                break;
            }
            case 2: {
                deviceType = ErrorEvent.DeviceType.TABLET;
                break;
            }
            case 3: {
                deviceType = ErrorEvent.DeviceType.TV;
                break;
            }
            case 4: {
                deviceType = ErrorEvent.DeviceType.DESKTOP;
                break;
            }
            default: {
                deviceType = ErrorEvent.DeviceType.OTHER;
            }
        }
        return deviceType;
    }

    @Nullable
    public static final ViewEvent.ViewEventSource tryFromSource(@NotNull ViewEvent.ViewEventSource.Companion $this$tryFromSource, @NotNull String source, @NotNull InternalLogger internalLogger) {
        ViewEvent.ViewEventSource viewEventSource;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            viewEventSource = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(source){
                final /* synthetic */ String $source;
                {
                    this.$source = $source;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "You are using an unknown source %s for your events";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$source};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            viewEventSource = null;
        }
        return viewEventSource;
    }

    @Nullable
    public static final LongTaskEvent.LongTaskEventSource tryFromSource(@NotNull LongTaskEvent.LongTaskEventSource.Companion $this$tryFromSource, @NotNull String source, @NotNull InternalLogger internalLogger) {
        LongTaskEvent.LongTaskEventSource longTaskEventSource;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            longTaskEventSource = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(source){
                final /* synthetic */ String $source;
                {
                    this.$source = $source;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "You are using an unknown source %s for your events";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$source};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            longTaskEventSource = null;
        }
        return longTaskEventSource;
    }

    @Nullable
    public static final ErrorEvent.ErrorEventSource tryFromSource(@NotNull ErrorEvent.ErrorEventSource.Companion $this$tryFromSource, @NotNull String source, @NotNull InternalLogger internalLogger) {
        ErrorEvent.ErrorEventSource errorEventSource;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            errorEventSource = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(source){
                final /* synthetic */ String $source;
                {
                    this.$source = $source;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "You are using an unknown source %s for your events";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$source};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            errorEventSource = null;
        }
        return errorEventSource;
    }

    @Nullable
    public static final ActionEvent.ActionEventSource tryFromSource(@NotNull ActionEvent.ActionEventSource.Companion $this$tryFromSource, @NotNull String source, @NotNull InternalLogger internalLogger) {
        ActionEvent.ActionEventSource actionEventSource;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            actionEventSource = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(source){
                final /* synthetic */ String $source;
                {
                    this.$source = $source;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "You are using an unknown source %s for your events";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$source};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            actionEventSource = null;
        }
        return actionEventSource;
    }

    @Nullable
    public static final ResourceEvent.ResourceEventSource tryFromSource(@NotNull ResourceEvent.ResourceEventSource.Companion $this$tryFromSource, @NotNull String source, @NotNull InternalLogger internalLogger) {
        ResourceEvent.ResourceEventSource resourceEventSource;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            resourceEventSource = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(source){
                final /* synthetic */ String $source;
                {
                    this.$source = $source;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "You are using an unknown source %s for your events";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$source};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            resourceEventSource = null;
        }
        return resourceEventSource;
    }

    @NotNull
    public static final ViewEvent.SessionPrecondition toViewSessionPrecondition(@NotNull RumSessionScope.StartReason $this$toViewSessionPrecondition) {
        ViewEvent.SessionPrecondition sessionPrecondition;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toViewSessionPrecondition), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$7[$this$toViewSessionPrecondition.ordinal()]) {
            case 1: {
                sessionPrecondition = ViewEvent.SessionPrecondition.USER_APP_LAUNCH;
                break;
            }
            case 2: {
                sessionPrecondition = ViewEvent.SessionPrecondition.INACTIVITY_TIMEOUT;
                break;
            }
            case 3: {
                sessionPrecondition = ViewEvent.SessionPrecondition.MAX_DURATION;
                break;
            }
            case 4: {
                sessionPrecondition = ViewEvent.SessionPrecondition.EXPLICIT_STOP;
                break;
            }
            case 5: {
                sessionPrecondition = ViewEvent.SessionPrecondition.BACKGROUND_LAUNCH;
                break;
            }
            case 6: {
                sessionPrecondition = ViewEvent.SessionPrecondition.PREWARM;
                break;
            }
            case 7: {
                sessionPrecondition = ViewEvent.SessionPrecondition.FROM_NON_INTERACTIVE_SESSION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sessionPrecondition;
    }

    @NotNull
    public static final ActionEvent.SessionPrecondition toActionSessionPrecondition(@NotNull RumSessionScope.StartReason $this$toActionSessionPrecondition) {
        ActionEvent.SessionPrecondition sessionPrecondition;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toActionSessionPrecondition), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$7[$this$toActionSessionPrecondition.ordinal()]) {
            case 1: {
                sessionPrecondition = ActionEvent.SessionPrecondition.USER_APP_LAUNCH;
                break;
            }
            case 2: {
                sessionPrecondition = ActionEvent.SessionPrecondition.INACTIVITY_TIMEOUT;
                break;
            }
            case 3: {
                sessionPrecondition = ActionEvent.SessionPrecondition.MAX_DURATION;
                break;
            }
            case 4: {
                sessionPrecondition = ActionEvent.SessionPrecondition.EXPLICIT_STOP;
                break;
            }
            case 5: {
                sessionPrecondition = ActionEvent.SessionPrecondition.BACKGROUND_LAUNCH;
                break;
            }
            case 6: {
                sessionPrecondition = ActionEvent.SessionPrecondition.PREWARM;
                break;
            }
            case 7: {
                sessionPrecondition = ActionEvent.SessionPrecondition.FROM_NON_INTERACTIVE_SESSION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sessionPrecondition;
    }

    @NotNull
    public static final ErrorEvent.SessionPrecondition toErrorSessionPrecondition(@NotNull RumSessionScope.StartReason $this$toErrorSessionPrecondition) {
        ErrorEvent.SessionPrecondition sessionPrecondition;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toErrorSessionPrecondition), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$7[$this$toErrorSessionPrecondition.ordinal()]) {
            case 1: {
                sessionPrecondition = ErrorEvent.SessionPrecondition.USER_APP_LAUNCH;
                break;
            }
            case 2: {
                sessionPrecondition = ErrorEvent.SessionPrecondition.INACTIVITY_TIMEOUT;
                break;
            }
            case 3: {
                sessionPrecondition = ErrorEvent.SessionPrecondition.MAX_DURATION;
                break;
            }
            case 4: {
                sessionPrecondition = ErrorEvent.SessionPrecondition.EXPLICIT_STOP;
                break;
            }
            case 5: {
                sessionPrecondition = ErrorEvent.SessionPrecondition.BACKGROUND_LAUNCH;
                break;
            }
            case 6: {
                sessionPrecondition = ErrorEvent.SessionPrecondition.PREWARM;
                break;
            }
            case 7: {
                sessionPrecondition = ErrorEvent.SessionPrecondition.FROM_NON_INTERACTIVE_SESSION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sessionPrecondition;
    }

    @NotNull
    public static final ResourceEvent.SessionPrecondition toResourceSessionPrecondition(@NotNull RumSessionScope.StartReason $this$toResourceSessionPrecondition) {
        ResourceEvent.SessionPrecondition sessionPrecondition;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toResourceSessionPrecondition), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$7[$this$toResourceSessionPrecondition.ordinal()]) {
            case 1: {
                sessionPrecondition = ResourceEvent.SessionPrecondition.USER_APP_LAUNCH;
                break;
            }
            case 2: {
                sessionPrecondition = ResourceEvent.SessionPrecondition.INACTIVITY_TIMEOUT;
                break;
            }
            case 3: {
                sessionPrecondition = ResourceEvent.SessionPrecondition.MAX_DURATION;
                break;
            }
            case 4: {
                sessionPrecondition = ResourceEvent.SessionPrecondition.EXPLICIT_STOP;
                break;
            }
            case 5: {
                sessionPrecondition = ResourceEvent.SessionPrecondition.BACKGROUND_LAUNCH;
                break;
            }
            case 6: {
                sessionPrecondition = ResourceEvent.SessionPrecondition.PREWARM;
                break;
            }
            case 7: {
                sessionPrecondition = ResourceEvent.SessionPrecondition.FROM_NON_INTERACTIVE_SESSION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sessionPrecondition;
    }

    @NotNull
    public static final LongTaskEvent.SessionPrecondition toLongTaskSessionPrecondition(@NotNull RumSessionScope.StartReason $this$toLongTaskSessionPrecondition) {
        LongTaskEvent.SessionPrecondition sessionPrecondition;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toLongTaskSessionPrecondition), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$7[$this$toLongTaskSessionPrecondition.ordinal()]) {
            case 1: {
                sessionPrecondition = LongTaskEvent.SessionPrecondition.USER_APP_LAUNCH;
                break;
            }
            case 2: {
                sessionPrecondition = LongTaskEvent.SessionPrecondition.INACTIVITY_TIMEOUT;
                break;
            }
            case 3: {
                sessionPrecondition = LongTaskEvent.SessionPrecondition.MAX_DURATION;
                break;
            }
            case 4: {
                sessionPrecondition = LongTaskEvent.SessionPrecondition.EXPLICIT_STOP;
                break;
            }
            case 5: {
                sessionPrecondition = LongTaskEvent.SessionPrecondition.BACKGROUND_LAUNCH;
                break;
            }
            case 6: {
                sessionPrecondition = LongTaskEvent.SessionPrecondition.PREWARM;
                break;
            }
            case 7: {
                sessionPrecondition = LongTaskEvent.SessionPrecondition.FROM_NON_INTERACTIVE_SESSION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sessionPrecondition;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;
        public static final /* synthetic */ int[] $EnumSwitchMapping$6;
        public static final /* synthetic */ int[] $EnumSwitchMapping$7;

        static {
            int[] nArray = new int[RumResourceMethod.values().length];
            try {
                nArray[RumResourceMethod.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.PUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.DELETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.PATCH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.TRACE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.OPTIONS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceMethod.CONNECT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RumResourceKind.values().length];
            try {
                nArray[RumResourceKind.BEACON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.FETCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.XHR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.DOCUMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.IMAGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.JS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.FONT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.CSS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.MEDIA.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.NATIVE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.UNKNOWN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumResourceKind.OTHER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RumErrorSource.values().length];
            try {
                nArray[RumErrorSource.NETWORK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSource.SOURCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSource.CONSOLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSource.LOGGER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSource.AGENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSource.WEBVIEW.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[RumErrorSourceType.values().length];
            try {
                nArray[RumErrorSourceType.ANDROID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSourceType.BROWSER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSourceType.REACT_NATIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSourceType.FLUTTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSourceType.NDK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumErrorSourceType.NDK_IL2CPP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[RumActionType.values().length];
            try {
                nArray[RumActionType.TAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumActionType.SCROLL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumActionType.SWIPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumActionType.CLICK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumActionType.BACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumActionType.CUSTOM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[NetworkInfo.Connectivity.values().length];
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_ETHERNET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_WIFI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_WIMAX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_BLUETOOTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_2G.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_3G.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_4G.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_5G.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_MOBILE_OTHER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_CELLULAR.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_OTHER.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$5 = nArray;
            nArray = new int[DeviceType.values().length];
            try {
                nArray[DeviceType.MOBILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.TABLET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.TV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.DESKTOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$6 = nArray;
            nArray = new int[RumSessionScope.StartReason.values().length];
            try {
                nArray[RumSessionScope.StartReason.USER_APP_LAUNCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumSessionScope.StartReason.INACTIVITY_TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumSessionScope.StartReason.MAX_DURATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumSessionScope.StartReason.EXPLICIT_STOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumSessionScope.StartReason.BACKGROUND_LAUNCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumSessionScope.StartReason.PREWARM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RumSessionScope.StartReason.FROM_NON_INTERACTIVE_SESSION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$7 = nArray;
        }
    }
}

