/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.event;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.constraints.DataConstraints;
import com.datadog.android.core.constraints.DatadogDataConstraints;
import com.datadog.android.core.internal.utils.JsonSerializer;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0017H\u0002J,\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001bH\u0002J,\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventSerializer;", "Lcom/datadog/android/core/persistence/Serializer;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dataConstraints", "Lcom/datadog/android/core/constraints/DataConstraints;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/constraints/DataConstraints;)V", "extractKnownAttributes", "Lcom/google/gson/JsonObject;", "jsonObject", "serialize", "", "model", "serializeActionEvent", "Lcom/datadog/android/rum/model/ActionEvent;", "serializeErrorEvent", "Lcom/datadog/android/rum/model/ErrorEvent;", "serializeLongTaskEvent", "Lcom/datadog/android/rum/model/LongTaskEvent;", "serializeResourceEvent", "Lcom/datadog/android/rum/model/ResourceEvent;", "serializeViewEvent", "Lcom/datadog/android/rum/model/ViewEvent;", "validateContextAttributes", "", "attributes", "", "validateUserAttributes", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nRumEventSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RumEventSerializer.kt\ncom/datadog/android/rum/internal/domain/event/RumEventSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n467#2,7:241\n766#3:248\n857#3,2:249\n1855#3,2:251\n*S KotlinDebug\n*F\n+ 1 RumEventSerializer.kt\ncom/datadog/android/rum/internal/domain/event/RumEventSerializer\n*L\n172#1:241,7\n194#1:248\n194#1:249,2\n195#1:251,2\n*E\n"})
public final class RumEventSerializer
implements Serializer<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final DataConstraints dataConstraints;
    @NotNull
    private static final Set<String> knownAttributes;
    @NotNull
    private static final Set<String> ignoredAttributes;
    @NotNull
    private static final Set<String> crossPlatformTransitAttributes;
    @NotNull
    public static final String GLOBAL_ATTRIBUTE_PREFIX = "context";
    @NotNull
    public static final String USER_ATTRIBUTE_PREFIX = "usr";
    @NotNull
    public static final String USER_EXTRA_GROUP_VERBOSE_NAME = "user extra information";

    public RumEventSerializer(@NotNull InternalLogger internalLogger, @NotNull DataConstraints dataConstraints) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)dataConstraints, (String)"dataConstraints");
        this.internalLogger = internalLogger;
        this.dataConstraints = dataConstraints;
    }

    public /* synthetic */ RumEventSerializer(InternalLogger internalLogger, DataConstraints dataConstraints, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dataConstraints = (DataConstraints)new DatadogDataConstraints(internalLogger);
        }
        this(internalLogger, dataConstraints);
    }

    @NotNull
    public String serialize(@NotNull Object model) {
        String string;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Object object = model;
        if (object instanceof ViewEvent) {
            string = this.serializeViewEvent((ViewEvent)model);
        } else if (object instanceof ErrorEvent) {
            string = this.serializeErrorEvent((ErrorEvent)model);
        } else if (object instanceof ActionEvent) {
            string = this.serializeActionEvent((ActionEvent)model);
        } else if (object instanceof ResourceEvent) {
            string = this.serializeResourceEvent((ResourceEvent)model);
        } else if (object instanceof LongTaskEvent) {
            string = this.serializeLongTaskEvent((LongTaskEvent)model);
        } else if (object instanceof TelemetryDebugEvent) {
            String string2 = ((TelemetryDebugEvent)model).toJson().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                model.\u2026.toString()\n            }");
            string = string2;
        } else if (object instanceof TelemetryErrorEvent) {
            String string3 = ((TelemetryErrorEvent)model).toJson().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                model.\u2026.toString()\n            }");
            string = string3;
        } else if (object instanceof TelemetryConfigurationEvent) {
            String string4 = ((TelemetryConfigurationEvent)model).toJson().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                model.\u2026.toString()\n            }");
            string = string4;
        } else if (object instanceof JsonObject) {
            string = model.toString();
        } else {
            String string5 = new JsonObject().toString();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n                JsonOb\u2026.toString()\n            }");
        }
        return string;
    }

    private final String serializeViewEvent(ViewEvent model) {
        ViewEvent.Usr usr = model.getUsr();
        ViewEvent.Usr sanitizedUser = usr != null ? ViewEvent.Usr.copy$default(usr, null, null, null, MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateUserAttributes(model.getUsr().getAdditionalProperties()), this.internalLogger)), 7, null) : null;
        ViewEvent.Context context = model.getContext();
        ViewEvent.Context sanitizedContext = context != null ? context.copy(MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateContextAttributes(model.getContext().getAdditionalProperties()), this.internalLogger))) : null;
        ViewEvent.CustomTimings customTimings = model.getView().getCustomTimings();
        ViewEvent.ViewEventView sanitizedView = ViewEvent.ViewEventView.copy$default(model.getView(), null, null, null, null, null, null, 0L, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, customTimings != null ? customTimings.copy(this.dataConstraints.validateTimings(model.getView().getCustomTimings().getAdditionalProperties())) : null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -4194305, 1023, null);
        ViewEvent sanitizedModel = ViewEvent.copy$default(model, 0L, null, null, null, null, null, null, null, sanitizedView, sanitizedUser, null, null, null, null, null, null, null, sanitizedContext, null, null, null, 1965311, null);
        JsonObject jsonObject = sanitizedModel.toJson().getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"sanitizedModel.toJson().asJsonObject");
        String string = this.extractKnownAttributes(jsonObject).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractKnownAttributes(s\u2026.asJsonObject).toString()");
        return string;
    }

    private final String serializeErrorEvent(ErrorEvent model) {
        ErrorEvent.Usr usr = model.getUsr();
        ErrorEvent.Usr sanitizedUser = usr != null ? ErrorEvent.Usr.copy$default(usr, null, null, null, MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateUserAttributes(model.getUsr().getAdditionalProperties()), this.internalLogger)), 7, null) : null;
        ErrorEvent.Context context = model.getContext();
        ErrorEvent.Context sanitizedContext = context != null ? context.copy(MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateContextAttributes(model.getContext().getAdditionalProperties()), this.internalLogger))) : null;
        ErrorEvent sanitizedModel = ErrorEvent.copy$default(model, 0L, null, null, null, null, null, null, null, null, sanitizedUser, null, null, null, null, null, null, null, sanitizedContext, null, null, null, null, 0x3DFDFF, null);
        JsonObject jsonObject = sanitizedModel.toJson().getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"sanitizedModel.toJson().asJsonObject");
        String string = this.extractKnownAttributes(jsonObject).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractKnownAttributes(s\u2026.asJsonObject).toString()");
        return string;
    }

    private final String serializeResourceEvent(ResourceEvent model) {
        ResourceEvent.Usr usr = model.getUsr();
        ResourceEvent.Usr sanitizedUser = usr != null ? ResourceEvent.Usr.copy$default(usr, null, null, null, MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateUserAttributes(model.getUsr().getAdditionalProperties()), this.internalLogger)), 7, null) : null;
        ResourceEvent.Context context = model.getContext();
        ResourceEvent.Context sanitizedContext = context != null ? context.copy(MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateContextAttributes(model.getContext().getAdditionalProperties()), this.internalLogger))) : null;
        ResourceEvent sanitizedModel = ResourceEvent.copy$default(model, 0L, null, null, null, null, null, null, null, null, sanitizedUser, null, null, null, null, null, null, null, sanitizedContext, null, null, null, 0x1DFDFF, null);
        JsonObject jsonObject = sanitizedModel.toJson().getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"sanitizedModel.toJson().asJsonObject");
        String string = this.extractKnownAttributes(jsonObject).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractKnownAttributes(s\u2026.asJsonObject).toString()");
        return string;
    }

    private final String serializeActionEvent(ActionEvent model) {
        ActionEvent.Usr usr = model.getUsr();
        ActionEvent.Usr sanitizedUser = usr != null ? ActionEvent.Usr.copy$default(usr, null, null, null, MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateUserAttributes(model.getUsr().getAdditionalProperties()), this.internalLogger)), 7, null) : null;
        ActionEvent.Context context = model.getContext();
        ActionEvent.Context sanitizedContext = context != null ? context.copy(MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateContextAttributes(model.getContext().getAdditionalProperties()), this.internalLogger))) : null;
        ActionEvent sanitizedModel = ActionEvent.copy$default(model, 0L, null, null, null, null, null, null, null, null, sanitizedUser, null, null, null, null, null, null, null, sanitizedContext, null, null, 916991, null);
        JsonObject jsonObject = sanitizedModel.toJson().getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"sanitizedModel.toJson().asJsonObject");
        String string = this.extractKnownAttributes(jsonObject).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractKnownAttributes(s\u2026.asJsonObject).toString()");
        return string;
    }

    private final String serializeLongTaskEvent(LongTaskEvent model) {
        LongTaskEvent.Usr usr = model.getUsr();
        LongTaskEvent.Usr sanitizedUser = usr != null ? LongTaskEvent.Usr.copy$default(usr, null, null, null, MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateUserAttributes(model.getUsr().getAdditionalProperties()), this.internalLogger)), 7, null) : null;
        LongTaskEvent.Context context = model.getContext();
        LongTaskEvent.Context sanitizedContext = context != null ? context.copy(MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(this.validateContextAttributes(model.getContext().getAdditionalProperties()), this.internalLogger))) : null;
        LongTaskEvent sanitizedModel = LongTaskEvent.copy$default(model, 0L, null, null, null, null, null, null, null, null, sanitizedUser, null, null, null, null, null, null, null, sanitizedContext, null, null, null, 0x1DFDFF, null);
        JsonObject jsonObject = sanitizedModel.toJson().getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"sanitizedModel.toJson().asJsonObject");
        String string = this.extractKnownAttributes(jsonObject).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractKnownAttributes(s\u2026.asJsonObject).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> validateContextAttributes(Map<String, ? extends Object> attributes) {
        void $this$filterKeys$iv;
        Map<String, ? extends Object> map = attributes;
        DataConstraints dataConstraints = this.dataConstraints;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!(!crossPlatformTransitAttributes.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return DataConstraints.DefaultImpls.validateAttributes$default((DataConstraints)dataConstraints, (Map)result$iv, (String)GLOBAL_ATTRIBUTE_PREFIX, null, ignoredAttributes, (int)4, null);
    }

    private final Map<String, Object> validateUserAttributes(Map<String, ? extends Object> attributes) {
        return this.dataConstraints.validateAttributes(attributes, USER_ATTRIBUTE_PREFIX, USER_EXTRA_GROUP_VERBOSE_NAME, ignoredAttributes);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject extractKnownAttributes(JsonObject jsonObject) {
        if (jsonObject.has(GLOBAL_ATTRIBUTE_PREFIX)) {
            void $this$filterTo$iv$iv;
            JsonObject contextObject = jsonObject.getAsJsonObject(GLOBAL_ATTRIBUTE_PREFIX);
            Set set = contextObject.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"contextObject\n                .entrySet()");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!knownAttributes.contains(it.getKey())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                contextObject.remove((String)it.getKey());
                jsonObject.add((String)it.getKey(), (JsonElement)it.getValue());
            }
        }
        return jsonObject;
    }

    static {
        Object[] objectArray = new String[]{"action.gesture.direction", "action.gesture.from_state", "action.gesture.to_state", "action.target.parent.resource_id", "action.target.parent.classname", "action.target.parent.index", "action.target.classname", "action.target.resource_id", "action.target.title", "error.resource.method", "error.resource.status_code", "error.resource.url"};
        knownAttributes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"_dd.timestamp", "_dd.error_type", "_dd.error.source_type", "_dd.error.is_crash"};
        ignoredAttributes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"_dd.timestamp", "_dd.error_type", "_dd.error.source_type", "_dd.error.is_crash"};
        crossPlatformTransitAttributes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventSerializer$Companion;", "", "()V", "GLOBAL_ATTRIBUTE_PREFIX", "", "USER_ATTRIBUTE_PREFIX", "USER_EXTRA_GROUP_VERBOSE_NAME", "crossPlatformTransitAttributes", "", "getCrossPlatformTransitAttributes$dd_sdk_android_rum_release", "()Ljava/util/Set;", "ignoredAttributes", "getIgnoredAttributes$dd_sdk_android_rum_release", "knownAttributes", "getKnownAttributes$dd_sdk_android_rum_release", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getKnownAttributes$dd_sdk_android_rum_release() {
            return knownAttributes;
        }

        @NotNull
        public final Set<String> getIgnoredAttributes$dd_sdk_android_rum_release() {
            return ignoredAttributes;
        }

        @NotNull
        public final Set<String> getCrossPlatformTransitAttributes$dd_sdk_android_rum_release() {
            return crossPlatformTransitAttributes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

