/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.event;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.event.EventMapper;
import com.datadog.android.event.NoOpEventMapper;
import com.datadog.android.rum.internal.domain.event.RumEventMapper;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,Bm\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0001H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0001H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u0001H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0010H\u00c2\u0003Js\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u0012\u0010&\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020\u0002H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020\u0002H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020\u0002H\u0002J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006-"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventMapper;", "Lcom/datadog/android/event/EventMapper;", "", "viewEventMapper", "Lcom/datadog/android/rum/model/ViewEvent;", "errorEventMapper", "Lcom/datadog/android/rum/model/ErrorEvent;", "resourceEventMapper", "Lcom/datadog/android/rum/model/ResourceEvent;", "actionEventMapper", "Lcom/datadog/android/rum/model/ActionEvent;", "longTaskEventMapper", "Lcom/datadog/android/rum/model/LongTaskEvent;", "telemetryConfigurationMapper", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/api/InternalLogger;)V", "getActionEventMapper", "()Lcom/datadog/android/event/EventMapper;", "getErrorEventMapper", "getLongTaskEventMapper", "getResourceEventMapper", "getTelemetryConfigurationMapper", "getViewEventMapper", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "map", "event", "mapRumEvent", "resolveEvent", "toString", "", "Companion", "dd-sdk-android-rum_release"})
public final class RumEventMapper
implements EventMapper<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventMapper<ViewEvent> viewEventMapper;
    @NotNull
    private final EventMapper<ErrorEvent> errorEventMapper;
    @NotNull
    private final EventMapper<ResourceEvent> resourceEventMapper;
    @NotNull
    private final EventMapper<ActionEvent> actionEventMapper;
    @NotNull
    private final EventMapper<LongTaskEvent> longTaskEventMapper;
    @NotNull
    private final EventMapper<TelemetryConfigurationEvent> telemetryConfigurationMapper;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String VIEW_EVENT_NULL_WARNING_MESSAGE = "RumEventMapper: the returned mapped ViewEvent was null. The original event object will be used instead: %s";
    @NotNull
    public static final String EVENT_NULL_WARNING_MESSAGE = "RumEventMapper: the returned mapped object was null. This event will be dropped: %s";
    @NotNull
    public static final String NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE = "RumEventMapper: the returned mapped object was not the same instance as the original object. This event will be dropped: %s";
    @NotNull
    public static final String NO_EVENT_MAPPER_ASSIGNED_WARNING_MESSAGE = "RumEventMapper: there was no EventMapper assigned for RUM event type: %s";
    @NotNull
    public static final String NO_DROPPING_FATAL_ERRORS_WARNING_MESSAGE = "RumEventMapper: the return from the ErrorEvent mapper was null for a crash. Dropping crashes in from the event mapper is not supported. The original event object will be used instead.";

    public RumEventMapper(@NotNull EventMapper<ViewEvent> viewEventMapper, @NotNull EventMapper<ErrorEvent> errorEventMapper, @NotNull EventMapper<ResourceEvent> resourceEventMapper, @NotNull EventMapper<ActionEvent> actionEventMapper, @NotNull EventMapper<LongTaskEvent> longTaskEventMapper, @NotNull EventMapper<TelemetryConfigurationEvent> telemetryConfigurationMapper, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(viewEventMapper, (String)"viewEventMapper");
        Intrinsics.checkNotNullParameter(errorEventMapper, (String)"errorEventMapper");
        Intrinsics.checkNotNullParameter(resourceEventMapper, (String)"resourceEventMapper");
        Intrinsics.checkNotNullParameter(actionEventMapper, (String)"actionEventMapper");
        Intrinsics.checkNotNullParameter(longTaskEventMapper, (String)"longTaskEventMapper");
        Intrinsics.checkNotNullParameter(telemetryConfigurationMapper, (String)"telemetryConfigurationMapper");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.viewEventMapper = viewEventMapper;
        this.errorEventMapper = errorEventMapper;
        this.resourceEventMapper = resourceEventMapper;
        this.actionEventMapper = actionEventMapper;
        this.longTaskEventMapper = longTaskEventMapper;
        this.telemetryConfigurationMapper = telemetryConfigurationMapper;
        this.internalLogger = internalLogger;
    }

    public /* synthetic */ RumEventMapper(EventMapper eventMapper, EventMapper eventMapper2, EventMapper eventMapper3, EventMapper eventMapper4, EventMapper eventMapper5, EventMapper eventMapper6, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eventMapper = (EventMapper)new NoOpEventMapper();
        }
        if ((n & 2) != 0) {
            eventMapper2 = (EventMapper)new NoOpEventMapper();
        }
        if ((n & 4) != 0) {
            eventMapper3 = (EventMapper)new NoOpEventMapper();
        }
        if ((n & 8) != 0) {
            eventMapper4 = (EventMapper)new NoOpEventMapper();
        }
        if ((n & 0x10) != 0) {
            eventMapper5 = (EventMapper)new NoOpEventMapper();
        }
        if ((n & 0x20) != 0) {
            eventMapper6 = (EventMapper)new NoOpEventMapper();
        }
        this((EventMapper<ViewEvent>)eventMapper, (EventMapper<ErrorEvent>)eventMapper2, (EventMapper<ResourceEvent>)eventMapper3, (EventMapper<ActionEvent>)eventMapper4, (EventMapper<LongTaskEvent>)eventMapper5, (EventMapper<TelemetryConfigurationEvent>)eventMapper6, internalLogger);
    }

    @NotNull
    public final EventMapper<ViewEvent> getViewEventMapper() {
        return this.viewEventMapper;
    }

    @NotNull
    public final EventMapper<ErrorEvent> getErrorEventMapper() {
        return this.errorEventMapper;
    }

    @NotNull
    public final EventMapper<ResourceEvent> getResourceEventMapper() {
        return this.resourceEventMapper;
    }

    @NotNull
    public final EventMapper<ActionEvent> getActionEventMapper() {
        return this.actionEventMapper;
    }

    @NotNull
    public final EventMapper<LongTaskEvent> getLongTaskEventMapper() {
        return this.longTaskEventMapper;
    }

    @NotNull
    public final EventMapper<TelemetryConfigurationEvent> getTelemetryConfigurationMapper() {
        return this.telemetryConfigurationMapper;
    }

    @Nullable
    public Object map(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.resolveEvent(event);
    }

    /*
     * WARNING - void declaration
     */
    private final Object mapRumEvent(Object event) {
        Object object;
        Object object2 = event;
        if (object2 instanceof ViewEvent) {
            object = this.viewEventMapper.map(event);
        } else if (object2 instanceof ActionEvent) {
            object = this.actionEventMapper.map(event);
        } else if (object2 instanceof ErrorEvent) {
            if (Intrinsics.areEqual((Object)((ErrorEvent)event).getError().isCrash(), (Object)true)) {
                ErrorEvent mappedEvent = (ErrorEvent)this.errorEventMapper.map(event);
                if (mappedEvent == null) {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)mapRumEvent.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                    object = (ErrorEvent)event;
                } else {
                    void var3_3;
                    object = var3_3;
                }
            } else {
                object = (ErrorEvent)this.errorEventMapper.map(event);
            }
        } else if (object2 instanceof ResourceEvent) {
            object = this.resourceEventMapper.map(event);
        } else if (object2 instanceof LongTaskEvent) {
            object = this.longTaskEventMapper.map(event);
        } else if (object2 instanceof TelemetryConfigurationEvent) {
            object = this.telemetryConfigurationMapper.map(event);
        } else if (object2 instanceof TelemetryDebugEvent ? true : object2 instanceof TelemetryErrorEvent) {
            object = event;
        } else {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ Object $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "RumEventMapper: there was no EventMapper assigned for RUM event type: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$event.getClass().getSimpleName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            object = event;
        }
        return object;
    }

    private final Object resolveEvent(Object event) {
        Object object;
        Object mappedEvent = this.mapRumEvent(event);
        if (event instanceof ViewEvent && (mappedEvent == null || mappedEvent != event)) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ Object $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "RumEventMapper: the returned mapped ViewEvent was null. The original event object will be used instead: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$event};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            object = event;
        } else if (mappedEvent == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ Object $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "RumEventMapper: the returned mapped object was null. This event will be dropped: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$event};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            object = null;
        } else if (mappedEvent != event) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ Object $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "RumEventMapper: the returned mapped object was not the same instance as the original object. This event will be dropped: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$event};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            object = null;
        } else {
            object = event;
        }
        return object;
    }

    @NotNull
    public final EventMapper<ViewEvent> component1() {
        return this.viewEventMapper;
    }

    @NotNull
    public final EventMapper<ErrorEvent> component2() {
        return this.errorEventMapper;
    }

    @NotNull
    public final EventMapper<ResourceEvent> component3() {
        return this.resourceEventMapper;
    }

    @NotNull
    public final EventMapper<ActionEvent> component4() {
        return this.actionEventMapper;
    }

    @NotNull
    public final EventMapper<LongTaskEvent> component5() {
        return this.longTaskEventMapper;
    }

    @NotNull
    public final EventMapper<TelemetryConfigurationEvent> component6() {
        return this.telemetryConfigurationMapper;
    }

    private final InternalLogger component7() {
        return this.internalLogger;
    }

    @NotNull
    public final RumEventMapper copy(@NotNull EventMapper<ViewEvent> viewEventMapper, @NotNull EventMapper<ErrorEvent> errorEventMapper, @NotNull EventMapper<ResourceEvent> resourceEventMapper, @NotNull EventMapper<ActionEvent> actionEventMapper, @NotNull EventMapper<LongTaskEvent> longTaskEventMapper, @NotNull EventMapper<TelemetryConfigurationEvent> telemetryConfigurationMapper, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(viewEventMapper, (String)"viewEventMapper");
        Intrinsics.checkNotNullParameter(errorEventMapper, (String)"errorEventMapper");
        Intrinsics.checkNotNullParameter(resourceEventMapper, (String)"resourceEventMapper");
        Intrinsics.checkNotNullParameter(actionEventMapper, (String)"actionEventMapper");
        Intrinsics.checkNotNullParameter(longTaskEventMapper, (String)"longTaskEventMapper");
        Intrinsics.checkNotNullParameter(telemetryConfigurationMapper, (String)"telemetryConfigurationMapper");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return new RumEventMapper(viewEventMapper, errorEventMapper, resourceEventMapper, actionEventMapper, longTaskEventMapper, telemetryConfigurationMapper, internalLogger);
    }

    public static /* synthetic */ RumEventMapper copy$default(RumEventMapper rumEventMapper, EventMapper eventMapper, EventMapper eventMapper2, EventMapper eventMapper3, EventMapper eventMapper4, EventMapper eventMapper5, EventMapper eventMapper6, InternalLogger internalLogger, int n, Object object) {
        if ((n & 1) != 0) {
            eventMapper = rumEventMapper.viewEventMapper;
        }
        if ((n & 2) != 0) {
            eventMapper2 = rumEventMapper.errorEventMapper;
        }
        if ((n & 4) != 0) {
            eventMapper3 = rumEventMapper.resourceEventMapper;
        }
        if ((n & 8) != 0) {
            eventMapper4 = rumEventMapper.actionEventMapper;
        }
        if ((n & 0x10) != 0) {
            eventMapper5 = rumEventMapper.longTaskEventMapper;
        }
        if ((n & 0x20) != 0) {
            eventMapper6 = rumEventMapper.telemetryConfigurationMapper;
        }
        if ((n & 0x40) != 0) {
            internalLogger = rumEventMapper.internalLogger;
        }
        return rumEventMapper.copy(eventMapper, eventMapper2, eventMapper3, eventMapper4, eventMapper5, eventMapper6, internalLogger);
    }

    @NotNull
    public String toString() {
        return "RumEventMapper(viewEventMapper=" + this.viewEventMapper + ", errorEventMapper=" + this.errorEventMapper + ", resourceEventMapper=" + this.resourceEventMapper + ", actionEventMapper=" + this.actionEventMapper + ", longTaskEventMapper=" + this.longTaskEventMapper + ", telemetryConfigurationMapper=" + this.telemetryConfigurationMapper + ", internalLogger=" + this.internalLogger + ")";
    }

    public int hashCode() {
        int result = this.viewEventMapper.hashCode();
        result = result * 31 + this.errorEventMapper.hashCode();
        result = result * 31 + this.resourceEventMapper.hashCode();
        result = result * 31 + this.actionEventMapper.hashCode();
        result = result * 31 + this.longTaskEventMapper.hashCode();
        result = result * 31 + this.telemetryConfigurationMapper.hashCode();
        result = result * 31 + this.internalLogger.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RumEventMapper)) {
            return false;
        }
        RumEventMapper rumEventMapper = (RumEventMapper)other;
        if (!Intrinsics.areEqual(this.viewEventMapper, rumEventMapper.viewEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.errorEventMapper, rumEventMapper.errorEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.resourceEventMapper, rumEventMapper.resourceEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actionEventMapper, rumEventMapper.actionEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.longTaskEventMapper, rumEventMapper.longTaskEventMapper)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.telemetryConfigurationMapper, rumEventMapper.telemetryConfigurationMapper)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.internalLogger, (Object)rumEventMapper.internalLogger);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventMapper$Companion;", "", "()V", "EVENT_NULL_WARNING_MESSAGE", "", "NOT_SAME_EVENT_INSTANCE_WARNING_MESSAGE", "NO_DROPPING_FATAL_ERRORS_WARNING_MESSAGE", "NO_EVENT_MAPPER_ASSIGNED_WARNING_MESSAGE", "VIEW_EVENT_NULL_WARNING_MESSAGE", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

