/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.core.persistence.SerializerKt;
import com.datadog.android.rum.internal.domain.event.RumEventMeta;
import com.datadog.android.rum.model.ViewEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0017R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/rum/internal/domain/RumDataWriter;", "Lcom/datadog/android/api/storage/DataWriter;", "", "eventSerializer", "Lcom/datadog/android/core/persistence/Serializer;", "eventMetaSerializer", "Lcom/datadog/android/rum/internal/domain/event/RumEventMeta;", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "(Lcom/datadog/android/core/persistence/Serializer;Lcom/datadog/android/core/persistence/Serializer;Lcom/datadog/android/core/InternalSdkCore;)V", "getEventSerializer$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/persistence/Serializer;", "onDataWritten", "", "data", "rawData", "", "onDataWritten$dd_sdk_android_rum_release", "write", "", "writer", "Lcom/datadog/android/api/storage/EventBatchWriter;", "element", "eventType", "Lcom/datadog/android/api/storage/EventType;", "Companion", "dd-sdk-android-rum_release"})
public final class RumDataWriter
implements DataWriter<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Serializer<Object> eventSerializer;
    @NotNull
    private final Serializer<RumEventMeta> eventMetaSerializer;
    @NotNull
    private final InternalSdkCore sdkCore;
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public RumDataWriter(@NotNull Serializer<Object> eventSerializer, @NotNull Serializer<RumEventMeta> eventMetaSerializer, @NotNull InternalSdkCore sdkCore) {
        Intrinsics.checkNotNullParameter(eventSerializer, (String)"eventSerializer");
        Intrinsics.checkNotNullParameter(eventMetaSerializer, (String)"eventMetaSerializer");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.eventSerializer = eventSerializer;
        this.eventMetaSerializer = eventMetaSerializer;
        this.sdkCore = sdkCore;
    }

    @NotNull
    public final Serializer<Object> getEventSerializer$dd_sdk_android_rum_release() {
        return this.eventSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean write(@NotNull EventBatchWriter writer, @NotNull Object element, @NotNull EventType eventType) {
        RawBatchEvent rawBatchEvent;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        byte[] byArray = SerializerKt.serializeToByteArray(this.eventSerializer, (Object)element, (InternalLogger)this.sdkCore.getInternalLogger());
        if (byArray == null) {
            return false;
        }
        byte[] byteArray = byArray;
        if (element instanceof ViewEvent) {
            RumEventMeta.View eventMeta = new RumEventMeta.View(((ViewEvent)element).getView().getId(), ((ViewEvent)element).getDd().getDocumentVersion());
            byte[] byArray2 = SerializerKt.serializeToByteArray(this.eventMetaSerializer, (Object)eventMeta, (InternalLogger)this.sdkCore.getInternalLogger());
            if (byArray2 == null) {
                byArray2 = EMPTY_BYTE_ARRAY;
            }
            byte[] serializedEventMeta = byArray2;
            rawBatchEvent = new RawBatchEvent(byteArray, serializedEventMeta);
        } else {
            rawBatchEvent = new RawBatchEvent(byteArray, null, 2, null);
        }
        RawBatchEvent batchEvent = rawBatchEvent;
        RumDataWriter rumDataWriter = this;
        synchronized (rumDataWriter) {
            boolean bl = false;
            boolean result = writer.write(batchEvent, null, eventType);
            if (result) {
                this.onDataWritten$dd_sdk_android_rum_release(element, byteArray);
            }
            boolean bl2 = result;
            return bl2;
        }
    }

    @WorkerThread
    public final void onDataWritten$dd_sdk_android_rum_release(@NotNull Object data, @NotNull byte[] rawData) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        if (data instanceof ViewEvent) {
            this.sdkCore.writeLastViewEvent(rawData);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/domain/RumDataWriter$Companion;", "", "()V", "EMPTY_BYTE_ARRAY", "", "getEMPTY_BYTE_ARRAY", "()[B", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getEMPTY_BYTE_ARRAY() {
            return EMPTY_BYTE_ARRAY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

