/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.debug;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.rum.internal.debug.RumDebugListener;
import com.datadog.android.rum.internal.debug.UiRumDebugListener;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.NoOpAdvancedRumMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0017J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010$\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0018\u0010&\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\"H\u0017J\u0010\u0010(\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010)\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0016\u0010*\u001a\u00020 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100,H\u0017J\u0016\u0010-\u001a\u00020 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100,H\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/datadog/android/rum/internal/debug/UiRumDebugListener;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/debug/RumDebugListener;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "advancedRumMonitor", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;)V", "rumViewsContainer", "Landroid/widget/LinearLayout;", "getRumViewsContainer$dd_sdk_android_rum_release", "()Landroid/widget/LinearLayout;", "setRumViewsContainer$dd_sdk_android_rum_release", "(Landroid/widget/LinearLayout;)V", "viewsSnapshot", "", "", "createDebugTextView", "Landroid/widget/TextView;", "context", "Landroid/content/Context;", "viewName", "alpha", "", "dpToPx", "dp", "", "findContentView", "Landroid/widget/FrameLayout;", "activity", "Landroid/app/Activity;", "onActivityCreated", "", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onReceiveRumActiveViews", "viewNames", "", "showRumViewsInfo", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nUiRumDebugListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiRumDebugListener.kt\ncom/datadog/android/rum/internal/debug/UiRumDebugListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1747#2,3:197\n*S KotlinDebug\n*F\n+ 1 UiRumDebugListener.kt\ncom/datadog/android/rum/internal/debug/UiRumDebugListener\n*L\n119#1:197,3\n*E\n"})
public final class UiRumDebugListener
implements Application.ActivityLifecycleCallbacks,
RumDebugListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final AdvancedRumMonitor advancedRumMonitor;
    @Nullable
    private LinearLayout rumViewsContainer;
    @NotNull
    private final List<String> viewsSnapshot;
    @NotNull
    public static final String CANNOT_FIND_CONTENT_VIEW_MESSAGE = "Cannot enable RUM debugging, because root content view can't be found";
    public static final int DEFAULT_ALPHA = 200;
    private static final int ACTIVE_COLOR = Color.rgb((int)99, (int)44, (int)166);

    public UiRumDebugListener(@NotNull FeatureSdkCore sdkCore, @NotNull AdvancedRumMonitor advancedRumMonitor) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)advancedRumMonitor, (String)"advancedRumMonitor");
        this.sdkCore = sdkCore;
        this.advancedRumMonitor = advancedRumMonitor;
        this.viewsSnapshot = new ArrayList();
    }

    @Nullable
    public final LinearLayout getRumViewsContainer$dd_sdk_android_rum_release() {
        return this.rumViewsContainer;
    }

    public final void setRumViewsContainer$dd_sdk_android_rum_release(@Nullable LinearLayout linearLayout) {
        this.rumViewsContainer = linearLayout;
    }

    @MainThread
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityResumed(@NotNull Activity activity) {
        LinearLayout $this$onActivityResumed_u24lambda_u240;
        LinearLayout linearLayout;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.advancedRumMonitor instanceof NoOpAdvancedRumMonitor) {
            return;
        }
        FrameLayout contentView = this.findContentView(activity);
        if (contentView == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)onActivityResumed.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        LinearLayout linearLayout2 = linearLayout = new LinearLayout((Context)activity);
        UiRumDebugListener uiRumDebugListener = this;
        boolean bl = false;
        $this$onActivityResumed_u24lambda_u240.setOrientation(1);
        uiRumDebugListener.rumViewsContainer = linearLayout;
        $this$onActivityResumed_u24lambda_u240 = linearLayout = new FrameLayout.LayoutParams(-1, -2);
        View view = (View)this.rumViewsContainer;
        uiRumDebugListener = contentView;
        boolean bl2 = false;
        $this$onActivityResumed_u24lambda_u241.gravity = 80;
        Unit unit = Unit.INSTANCE;
        uiRumDebugListener.addView(view, (ViewGroup.LayoutParams)linearLayout);
        this.advancedRumMonitor.setDebugListener(this);
    }

    @MainThread
    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.advancedRumMonitor instanceof NoOpAdvancedRumMonitor) {
            return;
        }
        FrameLayout frameLayout = this.findContentView(activity);
        if (frameLayout != null) {
            frameLayout.removeView((View)this.rumViewsContainer);
        }
        this.rumViewsContainer = null;
        this.advancedRumMonitor.setDebugListener(null);
        this.viewsSnapshot.clear();
    }

    @MainThread
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    @MainThread
    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    public void onReceiveRumActiveViews(@NotNull List<String> viewNames) {
        Intrinsics.checkNotNullParameter(viewNames, (String)"viewNames");
        List<String> list = this.viewsSnapshot;
        synchronized (list) {
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        boolean bl2 = false;
                        if (this.viewsSnapshot.isEmpty() || this.viewsSnapshot.size() != viewNames.size()) break block10;
                        Iterable $this$any$iv = CollectionsKt.withIndex((Iterable)this.viewsSnapshot);
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                IndexedValue it = (IndexedValue)element$iv;
                                boolean bl3 = false;
                                if (!(!Intrinsics.areEqual((Object)it.getValue(), (Object)CollectionsKt.getOrNull(viewNames, (int)it.getIndex())))) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block11;
                }
                this.viewsSnapshot.clear();
                this.viewsSnapshot.addAll((Collection<String>)viewNames);
                LinearLayout linearLayout = this.rumViewsContainer;
                if (linearLayout != null) {
                    linearLayout.post(() -> UiRumDebugListener.onReceiveRumActiveViews$lambda$4$lambda$3(this, viewNames));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @UiThread
    private final void showRumViewsInfo(List<String> viewNames) {
        block3: {
            LinearLayout linearLayout = this.rumViewsContainer;
            if (linearLayout == null) break block3;
            LinearLayout $this$showRumViewsInfo_u24lambda_u245 = linearLayout;
            boolean bl = false;
            $this$showRumViewsInfo_u24lambda_u245.removeAllViews();
            if (viewNames.isEmpty()) {
                Context context = $this$showRumViewsInfo_u24lambda_u245.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                $this$showRumViewsInfo_u24lambda_u245.addView((View)this.createDebugTextView(context, "No active RUM View", 200));
            } else {
                for (IndexedValue viewName : CollectionsKt.withIndex((Iterable)CollectionsKt.reversed((Iterable)viewNames))) {
                    Context context = $this$showRumViewsInfo_u24lambda_u245.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    $this$showRumViewsInfo_u24lambda_u245.addView((View)this.createDebugTextView(context, (String)viewName.getValue(), (int)((double)255 * Math.pow(0.75, viewName.getIndex() + 1))));
                }
            }
        }
    }

    private final TextView createDebugTextView(Context context, String viewName, int alpha) {
        TextView textView;
        TextView $this$createDebugTextView_u24lambda_u246 = textView = new TextView(context);
        boolean bl = false;
        $this$createDebugTextView_u24lambda_u246.setGravity(1);
        $this$createDebugTextView_u24lambda_u246.setBackgroundColor(Color.argb((int)alpha, (int)Color.red((int)ACTIVE_COLOR), (int)Color.green((int)ACTIVE_COLOR), (int)Color.blue((int)ACTIVE_COLOR)));
        $this$createDebugTextView_u24lambda_u246.setTextColor(-1);
        int paddingPx = this.dpToPx(2.0f, context);
        $this$createDebugTextView_u24lambda_u246.setPadding(paddingPx, paddingPx, paddingPx, paddingPx);
        $this$createDebugTextView_u24lambda_u246.setText((CharSequence)viewName);
        return textView;
    }

    private final FrameLayout findContentView(Activity activity) {
        View view = activity.getWindow().getDecorView();
        ViewGroup viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
        View view2 = viewGroup != null ? viewGroup.findViewById(0x1020002) : null;
        return view2 instanceof FrameLayout ? (FrameLayout)view2 : null;
    }

    private final int dpToPx(float dp, Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((double)(dp * displayMetrics.density) + 0.5);
    }

    private static final void onReceiveRumActiveViews$lambda$4$lambda$3(UiRumDebugListener this$0, List $viewNames) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$viewNames, (String)"$viewNames");
        this$0.showRumViewsInfo($viewNames);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/internal/debug/UiRumDebugListener$Companion;", "", "()V", "ACTIVE_COLOR", "", "getACTIVE_COLOR", "()I", "CANNOT_FIND_CONTENT_VIEW_MESSAGE", "", "DEFAULT_ALPHA", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getACTIVE_COLOR() {
            return ACTIVE_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

