/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.anr;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.feature.event.ThreadDump;
import com.datadog.android.rum.internal.anr.AndroidTraceParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\f\u0010\u000f\u001a\u00020\u0006*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/rum/internal/anr/AndroidTraceParser;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "convertThreadState", "", "threadState", "parse", "", "Lcom/datadog/android/core/feature/event/ThreadDump;", "traceInputStream", "Ljava/io/InputStream;", "parse$dd_sdk_android_rum_release", "trace", "safeReadText", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nAndroidTraceParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTraceParser.kt\ncom/datadog/android/rum/internal/anr/AndroidTraceParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class AndroidTraceParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String TRACE_STREAM_READ_FAILURE = "Failed to read crash trace stream.";
    @NotNull
    public static final String PARSING_FAILURE_MESSAGE = "Parsing tracing information for the exit reason wasn't successful, no thread dumps were parsed.";
    @NotNull
    private static final Regex THREAD_NAME_REGEX = new Regex("^\"(.+)\".+$");

    public AndroidTraceParser(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final List<ThreadDump> parse$dd_sdk_android_rum_release(@NotNull InputStream traceInputStream) {
        Intrinsics.checkNotNullParameter((Object)traceInputStream, (String)"traceInputStream");
        String trace = this.safeReadText(traceInputStream);
        if (StringsKt.isBlank((CharSequence)trace)) {
            return CollectionsKt.emptyList();
        }
        return this.parse(trace);
    }

    private final List<ThreadDump> parse(String trace) {
        List threadDumps = new ArrayList();
        boolean isInThreadStackBlock = false;
        List currentThreadStack = new ArrayList();
        String currentThreadName = null;
        String currentThreadState = null;
        for (String line : StringsKt.lines((CharSequence)trace)) {
            if (StringsKt.isBlank((CharSequence)line) && isInThreadStackBlock) {
                if (!((Collection)currentThreadStack).isEmpty() && currentThreadName != null) {
                    Collection collection = threadDumps;
                    String string = currentThreadState;
                    if (string == null) {
                        string = "";
                    }
                    collection.add(new ThreadDump(currentThreadName, this.convertThreadState(string), CollectionsKt.joinToString$default((Iterable)currentThreadStack, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), Intrinsics.areEqual(currentThreadName, (Object)"main")));
                }
                currentThreadStack.clear();
                isInThreadStackBlock = false;
                continue;
            }
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)" prio=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)" tid=", (boolean)false, (int)2, null)) {
                List list;
                String threadName;
                isInThreadStackBlock = true;
                String[] stringArray = new String[]{" "};
                String threadState = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                MatchResult matchResult = THREAD_NAME_REGEX.matchEntire((CharSequence)line);
                currentThreadName = threadName = matchResult != null && (list = matchResult.getGroupValues()) != null ? (String)CollectionsKt.getOrNull((List)list, (int)1) : null;
                currentThreadState = threadState;
                continue;
            }
            if (!isInThreadStackBlock) continue;
            String it = ((Object)StringsKt.trimStart((CharSequence)line)).toString();
            boolean bl = false;
            boolean bl2 = StringsKt.startsWith$default((String)it, (String)"at ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"native: ", (boolean)false, (int)2, null);
            if (!bl2) continue;
            ((Collection)currentThreadStack).add(line);
        }
        if (threadDumps.isEmpty()) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)parse.2.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
        return threadDumps;
    }

    private final String convertThreadState(String threadState) {
        String convertedState;
        String string = convertedState = Intrinsics.areEqual((Object)threadState, (Object)"TimedWaiting") ? "Timed_Waiting" : threadState;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String safeReadText(InputStream $this$safeReadText) {
        Object object;
        try {
            String string;
            object = $this$safeReadText;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                string = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)safeReadText.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            object = "";
        }
        return object;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/internal/anr/AndroidTraceParser$Companion;", "", "()V", "PARSING_FAILURE_MESSAGE", "", "THREAD_NAME_REGEX", "Lkotlin/text/Regex;", "getTHREAD_NAME_REGEX", "()Lkotlin/text/Regex;", "TRACE_STREAM_READ_FAILURE", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getTHREAD_NAME_REGEX() {
            return THREAD_NAME_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

