/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.domain.event;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.constraints.DataConstraints;
import com.datadog.android.core.constraints.DatadogDataConstraints;
import com.datadog.android.core.internal.utils.JsonSerializer;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.log.model.LogEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/log/internal/domain/event/LogEventSerializer;", "Lcom/datadog/android/core/persistence/Serializer;", "Lcom/datadog/android/log/model/LogEvent;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dataConstraints", "Lcom/datadog/android/core/constraints/DataConstraints;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/constraints/DataConstraints;)V", "sanitizeTagsAndAttributes", "log", "serialize", "", "model", "Companion", "dd-sdk-android-logs_release"})
@SourceDebugExtension(value={"SMAP\nLogEventSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogEventSerializer.kt\ncom/datadog/android/log/internal/domain/event/LogEventSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,58:1\n467#2,7:59\n*S KotlinDebug\n*F\n+ 1 LogEventSerializer.kt\ncom/datadog/android/log/internal/domain/event/LogEventSerializer\n*L\n32#1:59,7\n*E\n"})
public final class LogEventSerializer
implements Serializer<LogEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final DataConstraints dataConstraints;
    @NotNull
    public static final String USER_EXTRA_GROUP_VERBOSE_NAME = "user extra information";

    public LogEventSerializer(@NotNull InternalLogger internalLogger, @NotNull DataConstraints dataConstraints) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)dataConstraints, (String)"dataConstraints");
        this.internalLogger = internalLogger;
        this.dataConstraints = dataConstraints;
    }

    public /* synthetic */ LogEventSerializer(InternalLogger internalLogger, DataConstraints dataConstraints, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dataConstraints = (DataConstraints)new DatadogDataConstraints(internalLogger);
        }
        this(internalLogger, dataConstraints);
    }

    @NotNull
    public String serialize(@NotNull LogEvent model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        String string = this.sanitizeTagsAndAttributes(model).toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeTagsAndAttribute\u2026odel).toJson().toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final LogEvent sanitizeTagsAndAttributes(LogEvent log) {
        LogEvent.Usr usr;
        void $this$filterKeys$iv;
        String[] stringArray = new String[]{","};
        String sanitizedTags = CollectionsKt.joinToString$default((Iterable)this.dataConstraints.validateTags(StringsKt.split$default((CharSequence)log.getDdtags(), (String[])stringArray, (boolean)false, (int)0, (int)6, null)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Map map2 = DataConstraints.DefaultImpls.validateAttributes$default((DataConstraints)this.dataConstraints, log.getAdditionalProperties(), null, null, null, (int)14, null);
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map sanitizedAttributes = result$iv;
        LogEvent.Usr usr2 = log.getUsr();
        if (usr2 != null) {
            LogEvent.Usr it = usr2;
            boolean bl = false;
            Map sanitizedUserAttributes = DataConstraints.DefaultImpls.validateAttributes$default((DataConstraints)this.dataConstraints, it.getAdditionalProperties(), (String)"usr", (String)USER_EXTRA_GROUP_VERBOSE_NAME, null, (int)8, null);
            usr = LogEvent.Usr.copy$default(it, null, null, null, MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(sanitizedUserAttributes, this.internalLogger)), 7, null);
        } else {
            usr = null;
        }
        LogEvent.Usr usr3 = usr;
        Map map3 = MapsKt.toMutableMap((Map)JsonSerializer.INSTANCE.safeMapValuesToJson(sanitizedAttributes, this.internalLogger));
        return LogEvent.copy$default(log, null, null, null, null, null, null, usr3, null, null, null, sanitizedTags, map3, 959, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/log/internal/domain/event/LogEventSerializer$Companion;", "", "()V", "USER_EXTRA_GROUP_VERBOSE_NAME", "", "dd-sdk-android-logs_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

