/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal;

import android.content.Context;
import androidx.annotation.AnyThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.api.feature.FeatureEventReceiver;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.feature.StorageBackedFeature;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.api.storage.FeatureStorageConfiguration;
import com.datadog.android.api.storage.NoOpDataWriter;
import com.datadog.android.core.feature.event.JvmCrash;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.event.EventMapper;
import com.datadog.android.event.MapperSerializer;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.log.internal.domain.DatadogLogGenerator;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.domain.event.LogEventMapperWrapper;
import com.datadog.android.log.internal.domain.event.LogEventSerializer;
import com.datadog.android.log.internal.net.LogsRequestFactory;
import com.datadog.android.log.internal.storage.LogsDataWriter;
import com.datadog.android.log.model.LogEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0001DB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001f\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b1J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001b\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r04H\u0000\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u00020.2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\rH\u0017J\b\u0010;\u001a\u00020.H\u0016J\u0015\u0010<\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b=J\u0010\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020.2\u000e\u0010B\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304H\u0002J\u0018\u0010C\u001a\u00020.2\u000e\u0010B\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304H\u0002R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001e\"\u0004\b!\u0010\"R\u001b\u0010#\u001a\u00020$8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006E"}, d2={"Lcom/datadog/android/log/internal/LogsFeature;", "Lcom/datadog/android/api/feature/StorageBackedFeature;", "Lcom/datadog/android/api/feature/FeatureEventReceiver;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "customEndpointUrl", "", "eventMapper", "Lcom/datadog/android/event/EventMapper;", "Lcom/datadog/android/log/model/LogEvent;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Ljava/lang/String;Lcom/datadog/android/event/EventMapper;)V", "attributes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "dataWriter", "Lcom/datadog/android/api/storage/DataWriter;", "getDataWriter$dd_sdk_android_logs_release", "()Lcom/datadog/android/api/storage/DataWriter;", "setDataWriter$dd_sdk_android_logs_release", "(Lcom/datadog/android/api/storage/DataWriter;)V", "getEventMapper$dd_sdk_android_logs_release", "()Lcom/datadog/android/event/EventMapper;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_logs_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "logGenerator", "Lcom/datadog/android/log/internal/domain/DatadogLogGenerator;", "name", "getName", "()Ljava/lang/String;", "packageName", "getPackageName$dd_sdk_android_logs_release", "setPackageName$dd_sdk_android_logs_release", "(Ljava/lang/String;)V", "requestFactory", "Lcom/datadog/android/api/net/RequestFactory;", "getRequestFactory", "()Lcom/datadog/android/api/net/RequestFactory;", "requestFactory$delegate", "Lkotlin/Lazy;", "storageConfiguration", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "getStorageConfiguration", "()Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "addAttribute", "", "key", "value", "addAttribute$dd_sdk_android_logs_release", "createDataWriter", "getAttributes", "", "getAttributes$dd_sdk_android_logs_release", "onInitialize", "appContext", "Landroid/content/Context;", "onReceive", "event", "onStop", "removeAttribute", "removeAttribute$dd_sdk_android_logs_release", "sendJvmCrashLog", "jvmCrash", "Lcom/datadog/android/core/feature/event/JvmCrash$Logs;", "sendNdkCrashLog", "data", "sendSpanLog", "Companion", "dd-sdk-android-logs_release"})
@SourceDebugExtension(value={"SMAP\nLogsFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogsFeature.kt\ncom/datadog/android/log/internal/LogsFeature\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n467#2,7:324\n457#2:331\n403#2:332\n467#2,7:337\n457#2:344\n403#2:345\n1238#3,4:333\n1238#3,4:346\n*S KotlinDebug\n*F\n+ 1 LogsFeature.kt\ncom/datadog/android/log/internal/LogsFeature\n*L\n217#1:324,7\n218#1:331\n218#1:332\n260#1:337,7\n261#1:344\n261#1:345\n218#1:333,4\n261#1:346,4\n*E\n"})
public final class LogsFeature
implements StorageBackedFeature,
FeatureEventReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final EventMapper<LogEvent> eventMapper;
    @NotNull
    private DataWriter<LogEvent> dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private String packageName;
    @NotNull
    private final DatadogLogGenerator logGenerator;
    @NotNull
    private final ConcurrentHashMap<String, Object> attributes;
    @NotNull
    private final String name;
    @NotNull
    private final Lazy requestFactory$delegate;
    @NotNull
    private final FeatureStorageConfiguration storageConfiguration;
    @NotNull
    private static final String TYPE_EVENT_KEY = "type";
    @NotNull
    private static final String TIMESTAMP_EVENT_KEY = "timestamp";
    @NotNull
    private static final String LOGGER_NAME_EVENT_KEY = "loggerName";
    @NotNull
    private static final String ATTRIBUTES_EVENT_KEY = "attributes";
    @NotNull
    private static final String MESSAGE_EVENT_KEY = "message";
    @NotNull
    private static final String USER_INFO_EVENT_KEY = "userInfo";
    @NotNull
    private static final String NETWORK_INFO_EVENT_KEY = "networkInfo";
    @NotNull
    public static final String UNSUPPORTED_EVENT_TYPE = "Logs feature receive an event of unsupported type=%s.";
    @NotNull
    public static final String UNKNOWN_EVENT_TYPE_PROPERTY_VALUE = "Logs feature received an event with unknown value of \"type\" property=%s.";
    @NotNull
    public static final String NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING = "Logs feature received a NDK crash event where one or more mandatory (loggerName, message, timestamp, attributes) fields are either missing or have wrong type.";
    @NotNull
    public static final String SPAN_LOG_EVENT_MISSING_MANDATORY_FIELDS_WARNING = "Logs feature received a Span log event where one or more mandatory (loggerName, message, timestamp, attributes) fields are either missing or have wrong type.";
    public static final long MAX_WRITE_WAIT_TIMEOUT_MS = 500L;

    public LogsFeature(@NotNull FeatureSdkCore sdkCore, @Nullable String customEndpointUrl, @NotNull EventMapper<LogEvent> eventMapper) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
        this.sdkCore = sdkCore;
        this.eventMapper = eventMapper;
        this.dataWriter = (DataWriter)new NoOpDataWriter();
        this.initialized = new AtomicBoolean(false);
        this.packageName = "";
        this.logGenerator = new DatadogLogGenerator(null, 1, null);
        this.attributes = new ConcurrentHashMap();
        this.name = "logs";
        this.requestFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogsRequestFactory>(customEndpointUrl, this){
            final /* synthetic */ String $customEndpointUrl;
            final /* synthetic */ LogsFeature this$0;
            {
                this.$customEndpointUrl = $customEndpointUrl;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LogsRequestFactory invoke() {
                return new LogsRequestFactory(this.$customEndpointUrl, LogsFeature.access$getSdkCore$p(this.this$0).getInternalLogger());
            }
        }));
        this.storageConfiguration = FeatureStorageConfiguration.Companion.getDEFAULT();
    }

    @NotNull
    public final EventMapper<LogEvent> getEventMapper$dd_sdk_android_logs_release() {
        return this.eventMapper;
    }

    @NotNull
    public final DataWriter<LogEvent> getDataWriter$dd_sdk_android_logs_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_logs_release(@NotNull DataWriter<LogEvent> dataWriter) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"<set-?>");
        this.dataWriter = dataWriter;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_logs_release() {
        return this.initialized;
    }

    @NotNull
    public final String getPackageName$dd_sdk_android_logs_release() {
        return this.packageName;
    }

    public final void setPackageName$dd_sdk_android_logs_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packageName = string;
    }

    public final void addAttribute$dd_sdk_android_logs_release(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            ((Map)this.attributes).put(key, MapUtilsKt.getNULL_MAP_VALUE());
        } else {
            ((Map)this.attributes).put(key, value);
        }
    }

    public final void removeAttribute$dd_sdk_android_logs_release(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.attributes.remove(key);
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_logs_release() {
        return MapsKt.toMap((Map)this.attributes);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void onInitialize(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.sdkCore.setEventReceiver(this.getName(), (FeatureEventReceiver)this);
        String string = appContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appContext.packageName");
        this.packageName = string;
        this.dataWriter = this.createDataWriter(this.eventMapper);
        this.initialized.set(true);
    }

    @NotNull
    public RequestFactory getRequestFactory() {
        Lazy lazy = this.requestFactory$delegate;
        return (RequestFactory)lazy.getValue();
    }

    @NotNull
    public FeatureStorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void onStop() {
        this.sdkCore.removeEventReceiver(this.getName());
        this.dataWriter = (DataWriter)new NoOpDataWriter();
        this.packageName = "";
        this.initialized.set(false);
        this.attributes.clear();
    }

    @AnyThread
    public void onReceive(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof JvmCrash.Logs) {
            this.sendJvmCrashLog((JvmCrash.Logs)event);
            return;
        }
        if (!(event instanceof Map)) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ Object $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Logs feature receive an event of unsupported type=%s.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$event.getClass().getCanonicalName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            return;
        }
        if (Intrinsics.areEqual(((Map)event).get(TYPE_EVENT_KEY), (Object)"ndk_crash")) {
            this.sendNdkCrashLog((Map)event);
        } else if (Intrinsics.areEqual(((Map)event).get(TYPE_EVENT_KEY), (Object)"span_log")) {
            this.sendSpanLog((Map)event);
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ Object $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Logs feature received an event with unknown value of \"type\" property=%s.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{((Map)this.$event).get("type")};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
        }
    }

    private final DataWriter<LogEvent> createDataWriter(EventMapper<LogEvent> eventMapper) {
        return new LogsDataWriter((Serializer<LogEvent>)((Serializer)new MapperSerializer((EventMapper)new LogEventMapperWrapper(eventMapper, this.sdkCore.getInternalLogger()), (Serializer)new LogEventSerializer(this.sdkCore.getInternalLogger(), null, 2, null))), this.sdkCore.getInternalLogger());
    }

    private final void sendJvmCrashLog(JvmCrash.Logs jvmCrash) {
        CountDownLatch lock = new CountDownLatch(1);
        Map<String, Object> attributes = this.getAttributes$dd_sdk_android_logs_release();
        FeatureScope featureScope = this.sdkCore.getFeature(this.getName());
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, jvmCrash, attributes, lock){
                final /* synthetic */ LogsFeature this$0;
                final /* synthetic */ JvmCrash.Logs $jvmCrash;
                final /* synthetic */ Map<String, Object> $attributes;
                final /* synthetic */ CountDownLatch $lock;
                {
                    this.this$0 = $receiver;
                    this.$jvmCrash = $jvmCrash;
                    this.$attributes = $attributes;
                    this.$lock = $lock;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    DatadogLogGenerator datadogLogGenerator = LogsFeature.access$getLogGenerator$p(this.this$0);
                    String string = this.$jvmCrash.getLoggerName();
                    String string2 = this.$jvmCrash.getMessage();
                    Throwable throwable = this.$jvmCrash.getThrowable();
                    long l = this.$jvmCrash.getTimestamp();
                    String string3 = this.$jvmCrash.getThreadName();
                    List list = this.$jvmCrash.getThreads();
                    Set set = SetsKt.emptySet();
                    LogEvent log = datadogLogGenerator.generateLog(9, string2, throwable, this.$attributes, set, l, string3, datadogContext, true, string, true, true, null, null, list);
                    this.this$0.getDataWriter$dd_sdk_android_logs_release().write(eventBatchWriter, (Object)log, EventType.CRASH);
                    this.$lock.countDown();
                }
            }), (int)1, null);
        }
        try {
            lock.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)sendJvmCrashLog.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendNdkCrashLog(Map<?, ?> data) {
        UserInfo userInfo;
        Map map2;
        Map map3;
        Map map4;
        Object obj = data.get(TIMESTAMP_EVENT_KEY);
        Long timestamp = obj instanceof Long ? (Long)obj : null;
        Object obj2 = data.get(MESSAGE_EVENT_KEY);
        String message = obj2 instanceof String ? (String)obj2 : null;
        Object obj3 = data.get(LOGGER_NAME_EVENT_KEY);
        String loggerName = obj3 instanceof String ? (String)obj3 : null;
        Object obj4 = data.get(ATTRIBUTES_EVENT_KEY);
        Map map5 = map4 = obj4 instanceof Map ? (Map)obj4 : null;
        if (map4 != null) {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map $this$filterKeys$iv;
            map3 = map4;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                Object it = entry$iv.getKey();
                boolean bl = false;
                if (!(it instanceof String)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map6 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = (String)k;
                Map map7 = map6;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map7.put(string, entry);
            }
            map2 = destination$iv$iv;
        } else {
            map2 = null;
        }
        Map attributes = map2;
        obj4 = data.get(NETWORK_INFO_EVENT_KEY);
        NetworkInfo networkInfo = obj4 instanceof NetworkInfo ? (NetworkInfo)obj4 : null;
        map3 = data.get(USER_INFO_EVENT_KEY);
        UserInfo userInfo2 = userInfo = map3 instanceof UserInfo ? (UserInfo)map3 : null;
        if (loggerName == null || message == null || timestamp == null || attributes == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)sendNdkCrashLog.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        map3 = this.sdkCore.getFeature(this.getName());
        if (map3 != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)map3, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, message, (Map<String, ? extends Object>)attributes, timestamp, loggerName, userInfo, networkInfo){
                final /* synthetic */ LogsFeature this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ Map<String, Object> $attributes;
                final /* synthetic */ Long $timestamp;
                final /* synthetic */ String $loggerName;
                final /* synthetic */ UserInfo $userInfo;
                final /* synthetic */ NetworkInfo $networkInfo;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$attributes = $attributes;
                    this.$timestamp = $timestamp;
                    this.$loggerName = $loggerName;
                    this.$userInfo = $userInfo;
                    this.$networkInfo = $networkInfo;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    DatadogLogGenerator datadogLogGenerator = LogsFeature.access$getLogGenerator$p(this.this$0);
                    String string = Thread.currentThread().getName();
                    Set set = SetsKt.emptySet();
                    LogGenerator logGenerator = datadogLogGenerator;
                    long l = this.$timestamp;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    LogEvent log = LogGenerator.DefaultImpls.generateLog$default(logGenerator, 9, this.$message, null, this.$attributes, set, l, string, datadogContext, true, this.$loggerName, false, false, this.$userInfo, this.$networkInfo, null, 16384, null);
                    this.this$0.getDataWriter$dd_sdk_android_logs_release().write(eventBatchWriter, (Object)log, EventType.CRASH);
                }
            }), (int)1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendSpanLog(Map<?, ?> data) {
        Map attributes;
        Map map2;
        Map map3;
        Object obj = data.get(TIMESTAMP_EVENT_KEY);
        Long timestamp = obj instanceof Long ? (Long)obj : null;
        Object obj2 = data.get(MESSAGE_EVENT_KEY);
        String message = obj2 instanceof String ? (String)obj2 : null;
        Object obj3 = data.get(LOGGER_NAME_EVENT_KEY);
        String loggerName = obj3 instanceof String ? (String)obj3 : null;
        Object obj4 = data.get(ATTRIBUTES_EVENT_KEY);
        Map map4 = map3 = obj4 instanceof Map ? (Map)obj4 : null;
        if (map3 != null) {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map $this$filterKeys$iv;
            Map map5 = map3;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                Object it = entry$iv.getKey();
                boolean bl = false;
                if (!(it instanceof String)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map6 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = (String)k;
                Map map7 = map6;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map7.put(string, entry);
            }
            map2 = destination$iv$iv;
        } else {
            map2 = attributes = null;
        }
        if (loggerName == null || message == null || attributes == null || timestamp == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)sendSpanLog.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        map3 = this.sdkCore.getFeature(this.getName());
        if (map3 != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)map3, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, message, attributes, timestamp, loggerName){
                final /* synthetic */ LogsFeature this$0;
                final /* synthetic */ String $message;
                final /* synthetic */ Map<String, Object> $attributes;
                final /* synthetic */ Long $timestamp;
                final /* synthetic */ String $loggerName;
                {
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$attributes = $attributes;
                    this.$timestamp = $timestamp;
                    this.$loggerName = $loggerName;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    DatadogLogGenerator datadogLogGenerator = LogsFeature.access$getLogGenerator$p(this.this$0);
                    String string = Thread.currentThread().getName();
                    Set set = SetsKt.emptySet();
                    LogGenerator logGenerator = datadogLogGenerator;
                    long l = this.$timestamp;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    LogEvent log = LogGenerator.DefaultImpls.generateLog$default(logGenerator, 2, this.$message, null, this.$attributes, set, l, string, datadogContext, true, this.$loggerName, false, true, null, null, null, 28672, null);
                    this.this$0.getDataWriter$dd_sdk_android_logs_release().write(eventBatchWriter, (Object)log, EventType.DEFAULT);
                }
            }), (int)1, null);
        }
    }

    public static final /* synthetic */ DatadogLogGenerator access$getLogGenerator$p(LogsFeature $this) {
        return $this.logGenerator;
    }

    public static final /* synthetic */ FeatureSdkCore access$getSdkCore$p(LogsFeature $this) {
        return $this.sdkCore;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/log/internal/LogsFeature$Companion;", "", "()V", "ATTRIBUTES_EVENT_KEY", "", "LOGGER_NAME_EVENT_KEY", "MAX_WRITE_WAIT_TIMEOUT_MS", "", "MESSAGE_EVENT_KEY", "NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS_WARNING", "NETWORK_INFO_EVENT_KEY", "SPAN_LOG_EVENT_MISSING_MANDATORY_FIELDS_WARNING", "TIMESTAMP_EVENT_KEY", "TYPE_EVENT_KEY", "UNKNOWN_EVENT_TYPE_PROPERTY_VALUE", "UNSUPPORTED_EVENT_TYPE", "USER_INFO_EVENT_KEY", "dd-sdk-android-logs_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

