/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.error.internal;

import android.content.Context;
import androidx.work.WorkManager;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.feature.event.JvmCrash;
import com.datadog.android.core.feature.event.ThreadDump;
import com.datadog.android.core.internal.thread.ThreadPoolExecutorExtKt;
import com.datadog.android.core.internal.utils.ThreadExtKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.core.internal.utils.WorkManagerUtilsKt;
import com.datadog.android.error.internal.DatadogExceptionHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/error/internal/DatadogExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "appContext", "Landroid/content/Context;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Landroid/content/Context;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "previousHandler", "createCrashMessage", "", "throwable", "", "getThreadDumps", "", "Lcom/datadog/android/core/feature/event/ThreadDump;", "crashedThread", "Ljava/lang/Thread;", "e", "register", "", "safeGetAllStacktraces", "", "", "Ljava/lang/StackTraceElement;", "uncaughtException", "t", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nDatadogExceptionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatadogExceptionHandler.kt\ncom/datadog/android/error/internal/DatadogExceptionHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,177:1\n467#2,7:178\n483#2,7:185\n125#3:192\n152#3,3:193\n*S KotlinDebug\n*F\n+ 1 DatadogExceptionHandler.kt\ncom/datadog/android/error/internal/DatadogExceptionHandler\n*L\n133#1:178,7\n134#1:185,7\n135#1:192\n135#1:193,3\n*E\n"})
public final class DatadogExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final WeakReference<Context> contextRef;
    @Nullable
    private Thread.UncaughtExceptionHandler previousHandler;
    @NotNull
    public static final String LOGGER_NAME = "crash";
    @NotNull
    public static final String MESSAGE = "Application crash detected";
    public static final long MAX_WAIT_FOR_IDLE_TIME_IN_MS = 100L;
    @NotNull
    public static final String EXECUTOR_NOT_IDLED_WARNING_MESSAGE = "Datadog SDK is in an unexpected state due to an ongoing crash. Some events could be lost.";
    @NotNull
    public static final String MISSING_LOGS_FEATURE_INFO = "Logs feature is not registered, won't report crash as log.";
    @NotNull
    public static final String MISSING_RUM_FEATURE_INFO = "RUM feature is not registered, won't report crash as RUM event.";

    public DatadogExceptionHandler(@NotNull FeatureSdkCore sdkCore, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.sdkCore = sdkCore;
        this.contextRef = new WeakReference<Context>(appContext);
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            List<ThreadDump> threads = this.getThreadDumps(t, e);
            FeatureScope logsFeature = this.sdkCore.getFeature("logs");
            if (logsFeature != null) {
                String string = t.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"t.name");
                logsFeature.sendEvent(new JvmCrash.Logs(string, e, System.currentTimeMillis(), this.createCrashMessage(e), LOGGER_NAME, threads));
            } else {
                InternalLogger.DefaultImpls.log$default(this.sdkCore.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, (Function0)uncaughtException.1.INSTANCE, null, false, null, 56, null);
            }
            FeatureScope rumFeature = this.sdkCore.getFeature("rum");
            if (rumFeature != null) {
                rumFeature.sendEvent(new JvmCrash.Rum(e, this.createCrashMessage(e), threads));
            } else {
                InternalLogger.DefaultImpls.log$default(this.sdkCore.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, (Function0)uncaughtException.2.INSTANCE, null, false, null, 56, null);
            }
            if (this.sdkCore instanceof InternalSdkCore) {
                boolean idled;
                ExecutorService executorService = ((InternalSdkCore)this.sdkCore).getPersistenceExecutorService();
                ThreadPoolExecutor threadPoolExecutor = executorService instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)executorService : null;
                boolean bl = idled = threadPoolExecutor != null ? ThreadPoolExecutorExtKt.waitToIdle(threadPoolExecutor, 100L, this.sdkCore.getInternalLogger()) : true;
                if (!idled) {
                    InternalLogger.DefaultImpls.log$default(this.sdkCore.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)uncaughtException.3.INSTANCE, null, false, null, 56, null);
                }
            }
            Context context = (Context)this.contextRef.get();
            if (context != null) {
                Context it = context;
                boolean bl = false;
                if (WorkManager.isInitialized()) {
                    WorkManagerUtilsKt.triggerUploadWorker(it, this.sdkCore.getInternalLogger());
                }
            }
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.previousHandler;
            if (uncaughtExceptionHandler == null) break block8;
            uncaughtExceptionHandler.uncaughtException(t, e);
        }
    }

    public final void register() {
        this.previousHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    private final String createCrashMessage(Throwable throwable) {
        Object object;
        String rawMessage = throwable.getMessage();
        CharSequence charSequence = rawMessage;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String string = throwable.getClass().getCanonicalName();
            if (string == null) {
                string = throwable.getClass().getSimpleName();
            }
            String className = string;
            object = "Application crash detected: " + className;
        } else {
            object = rawMessage;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ThreadDump> getThreadDumps(Thread crashedThread, Throwable e) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map $this$filterValues$iv;
        StackTraceElement[] it;
        Map $this$filterKeys$iv;
        Object object = new ThreadDump[1];
        String string = crashedThread.getName();
        Thread.State state = crashedThread.getState();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)state), (String)"crashedThread.state");
        String string2 = ThreadExtKt.asString(state);
        Iterator iterator = ThrowableExtKt.loggableStackTrace(e);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        object[0] = new ThreadDump(string, string2, (String)((Object)iterator), true);
        Collection collection = CollectionsKt.mutableListOf((Object[])object);
        object = this.safeGetAllStacktraces();
        Collection collection2 = collection;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            it = (StackTraceElement[])entry$iv.getKey();
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)crashedThread))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            it = (StackTraceElement[])entry$iv.getValue();
            boolean bl = false;
            boolean bl2 = !(it.length == 0);
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            Thread thread = (Thread)it2.getKey();
            String string3 = thread.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"thread.name");
            Thread.State state2 = thread.getState();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)state2), (String)"thread.state");
            collection3.add(new ThreadDump(string3, ThreadExtKt.asString(state2), ThreadExtKt.loggableStackTrace((StackTraceElement[])it2.getValue()), false));
        }
        return CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
    }

    private final Map<Thread, StackTraceElement[]> safeGetAllStacktraces() {
        Map map;
        try {
            Map map2 = Thread.getAllStackTraces();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"{\n            Thread.getAllStackTraces()\n        }");
            map = map2;
        }
        catch (SecurityException e) {
            InternalLogger.DefaultImpls.log$default(this.sdkCore.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)safeGetAllStacktraces.1.INSTANCE, (Throwable)e, false, null, 48, null);
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/error/internal/DatadogExceptionHandler$Companion;", "", "()V", "EXECUTOR_NOT_IDLED_WARNING_MESSAGE", "", "LOGGER_NAME", "MAX_WAIT_FOR_IDLE_TIME_IN_MS", "", "MESSAGE", "MISSING_LOGS_FEATURE_INFO", "MISSING_RUM_FEATURE_INFO", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

