/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.persistence;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.tools.annotation.NoOpImplementation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bg\u0018\u00002\u00020\u0001:\u0002\u0013\u0014J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H'J\b\u0010\u0004\u001a\u00020\u0005H'J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H'J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0000H&J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH'J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH'J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H'\u00a8\u0006\u0015"}, d2={"Lcom/datadog/android/core/persistence/PersistenceStrategy;", "", "currentMetadata", "", "dropAll", "", "lockAndReadNext", "Lcom/datadog/android/core/persistence/PersistenceStrategy$Batch;", "migrateData", "targetStrategy", "unlockAndDelete", "batchId", "", "unlockAndKeep", "write", "", "event", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMetadata", "Batch", "Factory", "dd-sdk-android-core_release"})
@NoOpImplementation
public interface PersistenceStrategy {
    @WorkerThread
    @Nullable
    public byte[] currentMetadata();

    @WorkerThread
    public boolean write(@NotNull RawBatchEvent var1, @Nullable byte[] var2);

    @WorkerThread
    @Nullable
    public Batch lockAndReadNext();

    @WorkerThread
    public void unlockAndKeep(@NotNull String var1);

    @WorkerThread
    public void unlockAndDelete(@NotNull String var1);

    @WorkerThread
    public void dropAll();

    public void migrateData(@NotNull PersistenceStrategy var1);

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/core/persistence/PersistenceStrategy$Batch;", "", "batchId", "", "metadata", "", "events", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "(Ljava/lang/String;[BLjava/util/List;)V", "getBatchId", "()Ljava/lang/String;", "getEvents", "()Ljava/util/List;", "getMetadata", "()[B", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "dd-sdk-android-core_release"})
    public static final class Batch {
        @NotNull
        private final String batchId;
        @Nullable
        private final byte[] metadata;
        @NotNull
        private final List<RawBatchEvent> events;

        public Batch(@NotNull String batchId, @Nullable byte[] metadata, @NotNull List<RawBatchEvent> events) {
            Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.batchId = batchId;
            this.metadata = metadata;
            this.events = events;
        }

        public /* synthetic */ Batch(String string, byte[] byArray, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                byArray = null;
            }
            if ((n & 4) != 0) {
                list = new ArrayList();
            }
            this(string, byArray, list);
        }

        @NotNull
        public final String getBatchId() {
            return this.batchId;
        }

        @Nullable
        public final byte[] getMetadata() {
            return this.metadata;
        }

        @NotNull
        public final List<RawBatchEvent> getEvents() {
            return this.events;
        }

        @NotNull
        public final String component1() {
            return this.batchId;
        }

        @Nullable
        public final byte[] component2() {
            return this.metadata;
        }

        @NotNull
        public final List<RawBatchEvent> component3() {
            return this.events;
        }

        @NotNull
        public final Batch copy(@NotNull String batchId, @Nullable byte[] metadata, @NotNull List<RawBatchEvent> events) {
            Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            return new Batch(batchId, metadata, events);
        }

        public static /* synthetic */ Batch copy$default(Batch batch, String string, byte[] byArray, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = batch.batchId;
            }
            if ((n & 2) != 0) {
                byArray = batch.metadata;
            }
            if ((n & 4) != 0) {
                list = batch.events;
            }
            return batch.copy(string, byArray, list);
        }

        @NotNull
        public String toString() {
            return "Batch(batchId=" + this.batchId + ", metadata=" + Arrays.toString(this.metadata) + ", events=" + this.events + ")";
        }

        public int hashCode() {
            int result = this.batchId.hashCode();
            result = result * 31 + (this.metadata == null ? 0 : Arrays.hashCode(this.metadata));
            result = result * 31 + ((Object)this.events).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Batch)) {
                return false;
            }
            Batch batch = (Batch)other;
            if (!Intrinsics.areEqual((Object)this.batchId, (Object)batch.batchId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.metadata, (Object)batch.metadata)) {
                return false;
            }
            return Intrinsics.areEqual(this.events, batch.events);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;", "", "create", "Lcom/datadog/android/core/persistence/PersistenceStrategy;", "identifier", "", "maxItemsPerBatch", "", "maxBatchSize", "", "dd-sdk-android-core_release"})
    public static interface Factory {
        @NotNull
        public PersistenceStrategy create(@NotNull String var1, int var2, long var3);
    }
}

