/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.lint.InternalApi;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a:\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a*\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"ERROR_TASK_REJECTED", "", "executeSafe", "", "Ljava/util/concurrent/Executor;", "operationName", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "runnable", "Ljava/lang/Runnable;", "scheduleSafe", "Ljava/util/concurrent/ScheduledFuture;", "Ljava/util/concurrent/ScheduledExecutorService;", "delay", "", "unit", "Ljava/util/concurrent/TimeUnit;", "submitSafe", "Ljava/util/concurrent/Future;", "Ljava/util/concurrent/ExecutorService;", "dd-sdk-android-core_release"})
public final class ConcurrencyExtKt {
    @NotNull
    public static final String ERROR_TASK_REJECTED = "Unable to schedule %s task on the executor";

    @InternalApi
    public static final void executeSafe(@NotNull Executor $this$executeSafe, @NotNull String operationName, @NotNull InternalLogger internalLogger, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)$this$executeSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            $this$executeSafe.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(operationName){
                final /* synthetic */ String $operationName;
                {
                    this.$operationName = $operationName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to schedule %s task on the executor";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$operationName};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
        }
    }

    @InternalApi
    @Nullable
    public static final ScheduledFuture<?> scheduleSafe(@NotNull ScheduledExecutorService $this$scheduleSafe, @NotNull String operationName, long delay, @NotNull TimeUnit unit, @NotNull InternalLogger internalLogger, @NotNull Runnable runnable) {
        ScheduledFuture<?> scheduledFuture;
        Intrinsics.checkNotNullParameter((Object)$this$scheduleSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            scheduledFuture = $this$scheduleSafe.schedule(runnable, delay, unit);
        }
        catch (RejectedExecutionException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(operationName){
                final /* synthetic */ String $operationName;
                {
                    this.$operationName = $operationName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to schedule %s task on the executor";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$operationName};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    @InternalApi
    @Nullable
    public static final Future<?> submitSafe(@NotNull ExecutorService $this$submitSafe, @NotNull String operationName, @NotNull InternalLogger internalLogger, @NotNull Runnable runnable) {
        Future<?> future;
        Intrinsics.checkNotNullParameter((Object)$this$submitSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            future = $this$submitSafe.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(operationName){
                final /* synthetic */ String $operationName;
                {
                    this.$operationName = $operationName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to schedule %s task on the executor";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$operationName};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            future = null;
        }
        return future;
    }
}

