/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.thread;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.configuration.BackPressureMitigation;
import com.datadog.android.core.configuration.BackPressureStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/core/internal/thread/BackPressuredBlockingQueue;", "E", "", "Ljava/util/concurrent/LinkedBlockingQueue;", "logger", "Lcom/datadog/android/api/InternalLogger;", "executorContext", "", "backPressureStrategy", "Lcom/datadog/android/core/configuration/BackPressureStrategy;", "(Lcom/datadog/android/api/InternalLogger;Ljava/lang/String;Lcom/datadog/android/core/configuration/BackPressureStrategy;)V", "addWithBackPressure", "", "e", "operation", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "offer", "(Ljava/lang/Object;)Z", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z", "onItemDropped", "", "item", "(Ljava/lang/Object;)V", "onThresholdReached", "dd-sdk-android-core_release"})
public final class BackPressuredBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private final String executorContext;
    @NotNull
    private final BackPressureStrategy backPressureStrategy;

    public BackPressuredBlockingQueue(@NotNull InternalLogger logger, @NotNull String executorContext, @NotNull BackPressureStrategy backPressureStrategy) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)executorContext, (String)"executorContext");
        Intrinsics.checkNotNullParameter((Object)backPressureStrategy, (String)"backPressureStrategy");
        super(backPressureStrategy.getCapacity());
        this.logger = logger;
        this.executorContext = executorContext;
        this.backPressureStrategy = backPressureStrategy;
    }

    @Override
    public boolean offer(@NotNull E e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return this.addWithBackPressure(e, (Function1)new Function1<E, Boolean>(this){
            final /* synthetic */ BackPressuredBlockingQueue<E> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull E it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return BackPressuredBlockingQueue.access$offer$s355457059(this.this$0, it);
            }
        });
    }

    @Override
    public boolean offer(@NotNull E e, long timeout, @Nullable TimeUnit unit) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        boolean accepted = super.offer(e, timeout, unit);
        if (!accepted) {
            return this.offer(e);
        }
        if (this.remainingCapacity() == 0) {
            this.onThresholdReached();
        }
        return true;
    }

    private final boolean addWithBackPressure(E e, Function1<? super E, Boolean> operation) {
        boolean bl;
        block6: {
            int remainingCapacity;
            block5: {
                remainingCapacity = this.remainingCapacity();
                if (remainingCapacity != 0) break block5;
                switch (WhenMappings.$EnumSwitchMapping$0[this.backPressureStrategy.getBackpressureMitigation().ordinal()]) {
                    case 1: {
                        Object first = this.take();
                        Intrinsics.checkNotNullExpressionValue(first, (String)"first");
                        this.onItemDropped(first);
                        bl = (Boolean)operation.invoke(e);
                        break block6;
                    }
                    case 2: {
                        this.onItemDropped(e);
                        bl = true;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (remainingCapacity == 1) {
                this.onThresholdReached();
            }
            bl = (Boolean)operation.invoke(e);
        }
        return bl;
    }

    private final void onThresholdReached() {
        this.backPressureStrategy.getOnThresholdReached().invoke();
        InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
        List list = CollectionsKt.listOf((Object[])targetArray);
        targetArray = new Pair[]{TuplesKt.to((Object)"backpressure.capacity", (Object)this.backPressureStrategy.getCapacity()), TuplesKt.to((Object)"executor.context", (Object)this.executorContext)};
        this.logger.log(InternalLogger.Level.WARN, list, (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ BackPressuredBlockingQueue<E> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "BackPressuredBlockingQueue reached capacity:" + BackPressuredBlockingQueue.access$getBackPressureStrategy$p(this.this$0).getCapacity();
            }
        }), null, false, (Map<String, ? extends Object>)MapsKt.mapOf((Pair[])targetArray));
    }

    private final void onItemDropped(E item) {
        this.backPressureStrategy.getOnItemDropped().invoke(item);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"backpressure.capacity", (Object)this.backPressureStrategy.getCapacity()), TuplesKt.to((Object)"executor.context", (Object)this.executorContext)};
        this.logger.log(InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0<String>)((Function0)new Function0<String>(item){
            final /* synthetic */ E $item;
            {
                this.$item = $item;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Dropped item in BackPressuredBlockingQueue queue: " + this.$item;
            }
        }), null, false, (Map<String, ? extends Object>)MapsKt.mapOf((Pair[])pairArray));
    }

    public static final /* synthetic */ boolean access$offer$s355457059(BackPressuredBlockingQueue $this, Object p0) {
        return super.offer(p0);
    }

    public static final /* synthetic */ BackPressureStrategy access$getBackPressureStrategy$p(BackPressuredBlockingQueue $this) {
        return $this.backPressureStrategy;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackPressureMitigation.values().length];
            try {
                nArray[BackPressureMitigation.DROP_OLDEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackPressureMitigation.IGNORE_NEWEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

