/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.thread;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.configuration.BackPressureStrategy;
import com.datadog.android.core.internal.thread.BackPressureExecutorService;
import com.datadog.android.core.internal.thread.BackPressuredBlockingQueue;
import com.datadog.android.core.internal.thread.DatadogThreadFactory;
import com.datadog.android.core.internal.thread.ThreadExtKt;
import com.datadog.android.core.thread.FlushableExecutorService;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\r2\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/core/internal/thread/BackPressureExecutorService;", "Ljava/util/concurrent/ThreadPoolExecutor;", "Lcom/datadog/android/core/thread/FlushableExecutorService;", "logger", "Lcom/datadog/android/api/InternalLogger;", "executorContext", "", "backpressureStrategy", "Lcom/datadog/android/core/configuration/BackPressureStrategy;", "(Lcom/datadog/android/api/InternalLogger;Ljava/lang/String;Lcom/datadog/android/core/configuration/BackPressureStrategy;)V", "getLogger", "()Lcom/datadog/android/api/InternalLogger;", "afterExecute", "", "r", "Ljava/lang/Runnable;", "t", "", "drainTo", "destination", "", "onDrainException", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "Companion", "dd-sdk-android-core_release"})
public final class BackPressureExecutorService
extends ThreadPoolExecutor
implements FlushableExecutorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger logger;
    private static final int CORE_POOL_SIZE = 1;
    private static final long THREAD_POOL_MAX_KEEP_ALIVE_MS = TimeUnit.SECONDS.toMillis(5L);

    public BackPressureExecutorService(@NotNull InternalLogger logger, @NotNull String executorContext, @NotNull BackPressureStrategy backpressureStrategy) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)executorContext, (String)"executorContext");
        Intrinsics.checkNotNullParameter((Object)backpressureStrategy, (String)"backpressureStrategy");
        super(1, 1, THREAD_POOL_MAX_KEEP_ALIVE_MS, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new BackPressuredBlockingQueue(logger, executorContext, backpressureStrategy), new DatadogThreadFactory(executorContext));
        this.logger = logger;
    }

    @NotNull
    public final InternalLogger getLogger() {
        return this.logger;
    }

    @Override
    public void drainTo(@NotNull Collection<Runnable> destination) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        try {
            this.getQueue().drainTo(destination);
        }
        catch (IllegalArgumentException e) {
            this.onDrainException(e);
        }
        catch (NullPointerException e) {
            this.onDrainException(e);
        }
        catch (UnsupportedOperationException e) {
            this.onDrainException(e);
        }
        catch (ClassCastException e) {
            this.onDrainException(e);
        }
    }

    @Override
    protected void afterExecute(@Nullable Runnable r, @Nullable Throwable t) {
        super.afterExecute(r, t);
        ThreadExtKt.loggingAfterExecute(r, t, this.logger);
    }

    private final void onDrainException(RuntimeException e) {
        InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
        InternalLogger.DefaultImpls.log$default(this.logger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)onDrainException.1.INSTANCE, (Throwable)e, false, null, 48, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/thread/BackPressureExecutorService$Companion;", "", "()V", "CORE_POOL_SIZE", "", "THREAD_POOL_MAX_KEEP_ALIVE_MS", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

