/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.advanced;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.metrics.MetricsDispatcher;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.advanced.ConsentAwareFileMigrator;
import com.datadog.android.core.internal.persistence.file.advanced.ConsentAwareFileOrchestrator;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrator;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileOrchestrator;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.privacy.TrackingConsent;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/FeatureFileOrchestrator;", "Lcom/datadog/android/core/internal/persistence/file/advanced/ConsentAwareFileOrchestrator;", "consentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "storageDir", "Ljava/io/File;", "featureName", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "metricsDispatcher", "Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;", "(Lcom/datadog/android/core/internal/privacy/ConsentProvider;Ljava/io/File;Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;)V", "pendingOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "grantedOrchestrator", "dataMigrator", "Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;", "Lcom/datadog/android/privacy/TrackingConsent;", "(Lcom/datadog/android/core/internal/privacy/ConsentProvider;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/api/InternalLogger;)V", "Companion", "dd-sdk-android-core_release"})
public final class FeatureFileOrchestrator
extends ConsentAwareFileOrchestrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String BASE_DIR_NAME_REG_EX = "([a-z]+-)+";
    @NotNull
    private static final Regex IS_GRANTED_DIR_REG_EX = new Regex("([a-z]+-)+v[0-9]+");
    @NotNull
    private static final Regex IS_PENDING_DIR_REG_EX = new Regex("([a-z]+-)+pending-v[0-9]+");
    public static final int VERSION = 2;
    @NotNull
    public static final String PENDING_DIR = "%s-pending-v2";
    @NotNull
    public static final String GRANTED_DIR = "%s-v2";

    public FeatureFileOrchestrator(@NotNull ConsentProvider consentProvider, @NotNull FileOrchestrator pendingOrchestrator, @NotNull FileOrchestrator grantedOrchestrator, @NotNull DataMigrator<TrackingConsent> dataMigrator, @NotNull ExecutorService executorService, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)consentProvider, (String)"consentProvider");
        Intrinsics.checkNotNullParameter((Object)pendingOrchestrator, (String)"pendingOrchestrator");
        Intrinsics.checkNotNullParameter((Object)grantedOrchestrator, (String)"grantedOrchestrator");
        Intrinsics.checkNotNullParameter(dataMigrator, (String)"dataMigrator");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        super(consentProvider, pendingOrchestrator, grantedOrchestrator, dataMigrator, executorService, internalLogger);
    }

    public FeatureFileOrchestrator(@NotNull ConsentProvider consentProvider, @NotNull File storageDir, @NotNull String featureName, @NotNull ExecutorService executorService, @NotNull FilePersistenceConfig filePersistenceConfig, @NotNull InternalLogger internalLogger, @NotNull MetricsDispatcher metricsDispatcher) {
        Intrinsics.checkNotNullParameter((Object)consentProvider, (String)"consentProvider");
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)filePersistenceConfig, (String)"filePersistenceConfig");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)metricsDispatcher, (String)"metricsDispatcher");
        String string = PENDING_DIR;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{featureName};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
        FileOrchestrator fileOrchestrator = new BatchFileOrchestrator(new File(storageDir, string2), filePersistenceConfig, internalLogger, metricsDispatcher);
        string = GRANTED_DIR;
        locale = Locale.US;
        objectArray = new Object[]{featureName};
        String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
        this(consentProvider, fileOrchestrator, new BatchFileOrchestrator(new File(storageDir, string3), filePersistenceConfig, internalLogger, metricsDispatcher), new ConsentAwareFileMigrator(new FileMover(internalLogger), internalLogger), executorService, internalLogger);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/FeatureFileOrchestrator$Companion;", "", "()V", "BASE_DIR_NAME_REG_EX", "", "GRANTED_DIR", "IS_GRANTED_DIR_REG_EX", "Lkotlin/text/Regex;", "getIS_GRANTED_DIR_REG_EX$dd_sdk_android_core_release", "()Lkotlin/text/Regex;", "IS_PENDING_DIR_REG_EX", "getIS_PENDING_DIR_REG_EX$dd_sdk_android_core_release", "PENDING_DIR", "VERSION", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getIS_GRANTED_DIR_REG_EX$dd_sdk_android_core_release() {
            return IS_GRANTED_DIR_REG_EX;
        }

        @NotNull
        public final Regex getIS_PENDING_DIR_REG_EX$dd_sdk_android_core_release() {
            return IS_PENDING_DIR_REG_EX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

