/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.advanced;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrator;
import com.datadog.android.core.internal.persistence.file.advanced.MoveDataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.NoOpDataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.WipeDataMigrationOperation;
import com.datadog.android.privacy.TrackingConsent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\fH\u0017J*\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/ConsentAwareFileMigrator;", "Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrator;", "Lcom/datadog/android/privacy/TrackingConsent;", "fileMover", "Lcom/datadog/android/core/internal/persistence/file/FileMover;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/core/internal/persistence/file/FileMover;Lcom/datadog/android/api/InternalLogger;)V", "migrateData", "", "previousState", "previousFileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "newState", "newFileOrchestrator", "resolveMigrationOperation", "Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrationOperation;", "dd-sdk-android-core_release"})
public final class ConsentAwareFileMigrator
implements DataMigrator<TrackingConsent> {
    @NotNull
    private final FileMover fileMover;
    @NotNull
    private final InternalLogger internalLogger;

    public ConsentAwareFileMigrator(@NotNull FileMover fileMover, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)fileMover, (String)"fileMover");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.fileMover = fileMover;
        this.internalLogger = internalLogger;
    }

    @Override
    @WorkerThread
    public void migrateData(@Nullable TrackingConsent previousState, @NotNull FileOrchestrator previousFileOrchestrator, @NotNull TrackingConsent newState, @NotNull FileOrchestrator newFileOrchestrator) {
        Intrinsics.checkNotNullParameter((Object)previousFileOrchestrator, (String)"previousFileOrchestrator");
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        Intrinsics.checkNotNullParameter((Object)newFileOrchestrator, (String)"newFileOrchestrator");
        DataMigrationOperation operation = this.resolveMigrationOperation(previousState, newState, previousFileOrchestrator, newFileOrchestrator);
        operation.run();
    }

    @WorkerThread
    private final DataMigrationOperation resolveMigrationOperation(TrackingConsent previousState, TrackingConsent newState, FileOrchestrator previousFileOrchestrator, FileOrchestrator newFileOrchestrator) {
        DataMigrationOperation dataMigrationOperation;
        Pair pair = TuplesKt.to((Object)((Object)previousState), (Object)((Object)newState));
        if (((Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to(null, (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.NOT_GRANTED)))) {
            dataMigrationOperation = new WipeDataMigrationOperation(previousFileOrchestrator.getRootDir(), this.fileMover, this.internalLogger);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.PENDING)))) {
            dataMigrationOperation = new WipeDataMigrationOperation(newFileOrchestrator.getRootDir(), this.fileMover, this.internalLogger);
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.GRANTED)))) {
            dataMigrationOperation = new MoveDataMigrationOperation(previousFileOrchestrator.getRootDir(), newFileOrchestrator.getRootDir(), this.fileMover, this.internalLogger);
        } else if ((((Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.PENDING), (Object)((Object)TrackingConsent.PENDING))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.GRANTED), (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.NOT_GRANTED)))) ? true : Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)TrackingConsent.NOT_GRANTED), (Object)((Object)TrackingConsent.GRANTED)))) {
            dataMigrationOperation = new NoOpDataMigrationOperation();
        } else {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(previousState, newState){
                final /* synthetic */ TrackingConsent $previousState;
                final /* synthetic */ TrackingConsent $newState;
                {
                    this.$previousState = $previousState;
                    this.$newState = $newState;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unexpected consent migration from " + this.$previousState + " to " + this.$newState;
                }
            }, null, false, null, 56, null);
            dataMigrationOperation = new NoOpDataMigrationOperation();
        }
        return dataMigrationOperation;
    }
}

