/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net.info;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.core.internal.net.info.CallbackNetworkInfoProvider;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.system.BuildSdkVersionProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0001\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/datadog/android/core/internal/net/info/CallbackNetworkInfoProvider;", "Landroid/net/ConnectivityManager$NetworkCallback;", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "dataWriter", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "Lcom/datadog/android/api/context/NetworkInfo;", "buildSdkVersionProvider", "Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/core/internal/persistence/DataWriter;Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;Lcom/datadog/android/api/InternalLogger;)V", "value", "lastNetworkInfo", "setLastNetworkInfo", "(Lcom/datadog/android/api/context/NetworkInfo;)V", "getLatestNetworkInfo", "getNetworkType", "Lcom/datadog/android/api/context/NetworkInfo$Connectivity;", "networkCapabilities", "Landroid/net/NetworkCapabilities;", "onCapabilitiesChanged", "", "network", "Landroid/net/Network;", "onLost", "register", "context", "Landroid/content/Context;", "resolveDownBandwidth", "", "(Landroid/net/NetworkCapabilities;)Ljava/lang/Long;", "resolveStrength", "resolveUpBandwidth", "unregister", "Companion", "dd-sdk-android-core_release"})
@TargetApi(value=24)
public final class CallbackNetworkInfoProvider
extends ConnectivityManager.NetworkCallback
implements NetworkInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataWriter<NetworkInfo> dataWriter;
    @NotNull
    private final BuildSdkVersionProvider buildSdkVersionProvider;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private NetworkInfo lastNetworkInfo;
    @NotNull
    public static final String ERROR_REGISTER = "We couldn't register a Network Callback, the network information reported will be less accurate.";
    @NotNull
    public static final String ERROR_UNREGISTER = "We couldn't unregister the Network Callback";

    public CallbackNetworkInfoProvider(@NotNull DataWriter<NetworkInfo> dataWriter, @NotNull BuildSdkVersionProvider buildSdkVersionProvider, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(dataWriter, (String)"dataWriter");
        Intrinsics.checkNotNullParameter((Object)buildSdkVersionProvider, (String)"buildSdkVersionProvider");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.dataWriter = dataWriter;
        this.buildSdkVersionProvider = buildSdkVersionProvider;
        this.internalLogger = internalLogger;
        this.lastNetworkInfo = new NetworkInfo(null, null, null, null, null, null, null, 127, null);
    }

    public /* synthetic */ CallbackNetworkInfoProvider(DataWriter dataWriter, BuildSdkVersionProvider buildSdkVersionProvider, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            buildSdkVersionProvider = BuildSdkVersionProvider.Companion.getDEFAULT();
        }
        this(dataWriter, buildSdkVersionProvider, internalLogger);
    }

    private final void setLastNetworkInfo(NetworkInfo value) {
        this.lastNetworkInfo = value;
        this.dataWriter.write(this.lastNetworkInfo);
    }

    public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
        super.onCapabilitiesChanged(network, networkCapabilities);
        this.setLastNetworkInfo(new NetworkInfo(this.getNetworkType(networkCapabilities), null, null, this.resolveUpBandwidth(networkCapabilities), this.resolveDownBandwidth(networkCapabilities), this.resolveStrength(networkCapabilities), null, 70, null));
    }

    public void onLost(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        super.onLost(network);
        this.setLastNetworkInfo(new NetworkInfo(NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED, null, null, null, null, null, null, 126, null));
    }

    @Override
    public void register(@NotNull Context context) {
        ConnectivityManager connMgr;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object systemService = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = connMgr = systemService instanceof ConnectivityManager ? (ConnectivityManager)systemService : null;
        if (connMgr == null) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)register.1.INSTANCE, null, false, null, 56, null);
            return;
        }
        try {
            connMgr.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this);
            Network activeNetwork = connMgr.getActiveNetwork();
            NetworkCapabilities activeCaps = connMgr.getNetworkCapabilities(activeNetwork);
            if (activeNetwork != null && activeCaps != null) {
                this.onCapabilitiesChanged(activeNetwork, activeCaps);
            }
        }
        catch (SecurityException e) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)register.2.INSTANCE, (Throwable)e, false, null, 48, null);
            this.setLastNetworkInfo(new NetworkInfo(NetworkInfo.Connectivity.NETWORK_OTHER, null, null, null, null, null, null, 126, null));
        }
        catch (Exception e) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)register.3.INSTANCE, (Throwable)e, false, null, 48, null);
            this.setLastNetworkInfo(new NetworkInfo(NetworkInfo.Connectivity.NETWORK_OTHER, null, null, null, null, null, null, 126, null));
        }
    }

    @Override
    public void unregister(@NotNull Context context) {
        ConnectivityManager connMgr;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object systemService = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = connMgr = systemService instanceof ConnectivityManager ? (ConnectivityManager)systemService : null;
        if (connMgr == null) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)unregister.1.INSTANCE, null, false, null, 56, null);
            return;
        }
        try {
            connMgr.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this);
        }
        catch (SecurityException e) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)unregister.2.INSTANCE, (Throwable)e, false, null, 48, null);
        }
        catch (RuntimeException e) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)unregister.3.INSTANCE, (Throwable)e, false, null, 48, null);
        }
    }

    @Override
    @NotNull
    public NetworkInfo getLatestNetworkInfo() {
        return this.lastNetworkInfo;
    }

    private final Long resolveUpBandwidth(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.getLinkUpstreamBandwidthKbps() > 0 ? Long.valueOf(networkCapabilities.getLinkUpstreamBandwidthKbps()) : null;
    }

    private final Long resolveDownBandwidth(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.getLinkDownstreamBandwidthKbps() > 0 ? Long.valueOf(networkCapabilities.getLinkDownstreamBandwidthKbps()) : null;
    }

    @SuppressLint(value={"NewApi"})
    private final Long resolveStrength(NetworkCapabilities networkCapabilities) {
        return this.buildSdkVersionProvider.getVersion() >= 29 && networkCapabilities.getSignalStrength() != Integer.MIN_VALUE ? Long.valueOf(networkCapabilities.getSignalStrength()) : null;
    }

    private final NetworkInfo.Connectivity getNetworkType(NetworkCapabilities networkCapabilities) {
        return networkCapabilities.hasTransport(1) ? NetworkInfo.Connectivity.NETWORK_WIFI : (networkCapabilities.hasTransport(3) ? NetworkInfo.Connectivity.NETWORK_ETHERNET : (networkCapabilities.hasTransport(0) ? NetworkInfo.Connectivity.NETWORK_CELLULAR : (networkCapabilities.hasTransport(2) ? NetworkInfo.Connectivity.NETWORK_BLUETOOTH : NetworkInfo.Connectivity.NETWORK_OTHER)));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/net/info/CallbackNetworkInfoProvider$Companion;", "", "()V", "ERROR_REGISTER", "", "ERROR_UNREGISTER", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

