/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import android.content.Context;
import androidx.annotation.WorkerThread;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.NoOpInternalSdkCore;
import com.datadog.android.core.internal.SdkFeature;
import com.datadog.android.core.internal.data.upload.DataUploader;
import com.datadog.android.core.internal.data.upload.UploadStatus;
import com.datadog.android.core.internal.data.upload.UploadWorker;
import com.datadog.android.core.internal.metrics.RemovalReason;
import com.datadog.android.core.internal.persistence.BatchData;
import com.datadog.android.core.internal.persistence.Storage;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker;", "Landroidx/work/Worker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "Companion", "UploadNextBatchTask", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nUploadWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadWorker.kt\ncom/datadog/android/core/internal/data/upload/UploadWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1603#2,9:125\n1855#2:134\n1856#2:136\n1612#2:137\n1855#2,2:138\n1#3:135\n*S KotlinDebug\n*F\n+ 1 UploadWorker.kt\ncom/datadog/android/core/internal/data/upload/UploadWorker\n*L\n52#1:125,9\n52#1:134\n52#1:136\n52#1:137\n56#1:138,2\n52#1:135\n*E\n"})
public final class UploadWorker
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String MESSAGE_NOT_INITIALIZED = "Datadog has not been initialized.";
    @NotNull
    public static final String DATADOG_INSTANCE_NAME = "_dd.sdk.instanceName";

    public UploadWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public ListenableWorker.Result doWork() {
        void $this$mapNotNullTo$iv$iv;
        InternalSdkCore sdkCore;
        String instanceName = this.getInputData().getString(DATADOG_INSTANCE_NAME);
        SdkCore sdkCore2 = Datadog.getInstance(instanceName);
        InternalSdkCore internalSdkCore = sdkCore = sdkCore2 instanceof InternalSdkCore ? (InternalSdkCore)sdkCore2 : null;
        if (sdkCore == null || sdkCore instanceof NoOpInternalSdkCore) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getUnboundInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)doWork.1.INSTANCE, null, false, null, 56, null);
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
            return result;
        }
        Iterable $this$mapNotNull$iv = sdkCore.getAllFeatures();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SdkFeature it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FeatureScope it = (FeatureScope)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof SdkFeature ? (SdkFeature)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List features = CollectionsKt.shuffled((Iterable)((List)destination$iv$iv));
        LinkedList<UploadNextBatchTask> tasksQueue = new LinkedList<UploadNextBatchTask>();
        Iterable $this$forEach$iv = features;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkFeature it = (SdkFeature)element$iv;
            boolean bl = false;
            tasksQueue.offer(new UploadNextBatchTask((Queue<UploadNextBatchTask>)tasksQueue, sdkCore, it));
        }
        while (!tasksQueue.isEmpty()) {
            UploadNextBatchTask uploadNextBatchTask = (UploadNextBatchTask)tasksQueue.poll();
            if (uploadNextBatchTask == null) continue;
            uploadNextBatchTask.run();
        }
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker$Companion;", "", "()V", "DATADOG_INSTANCE_NAME", "", "MESSAGE_NOT_INITIALIZED", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadWorker$UploadNextBatchTask;", "Ljava/lang/Runnable;", "taskQueue", "Ljava/util/Queue;", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "feature", "Lcom/datadog/android/core/internal/SdkFeature;", "(Ljava/util/Queue;Lcom/datadog/android/core/InternalSdkCore;Lcom/datadog/android/core/internal/SdkFeature;)V", "consumeBatch", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "context", "Lcom/datadog/android/api/context/DatadogContext;", "batch", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMeta", "", "uploader", "Lcom/datadog/android/core/internal/data/upload/DataUploader;", "run", "", "dd-sdk-android-core_release"})
    public static final class UploadNextBatchTask
    implements Runnable {
        @NotNull
        private final Queue<UploadNextBatchTask> taskQueue;
        @NotNull
        private final InternalSdkCore sdkCore;
        @NotNull
        private final SdkFeature feature;

        public UploadNextBatchTask(@NotNull Queue<UploadNextBatchTask> taskQueue, @NotNull InternalSdkCore sdkCore, @NotNull SdkFeature feature) {
            Intrinsics.checkNotNullParameter(taskQueue, (String)"taskQueue");
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            this.taskQueue = taskQueue;
            this.sdkCore = sdkCore;
            this.feature = feature;
        }

        @Override
        @WorkerThread
        public void run() {
            DatadogContext datadogContext = this.sdkCore.getDatadogContext();
            if (datadogContext == null) {
                return;
            }
            DatadogContext context = datadogContext;
            Storage storage = this.feature.getStorage$dd_sdk_android_core_release();
            DataUploader uploader = this.feature.getUploader$dd_sdk_android_core_release();
            BatchData nextBatchData = storage.readNextBatch();
            if (nextBatchData != null) {
                UploadStatus uploadStatus2 = this.consumeBatch(context, nextBatchData.getData(), nextBatchData.getMetadata(), uploader);
                storage.confirmBatchRead(nextBatchData.getId(), new RemovalReason.IntakeCode(uploadStatus2.getCode()), !uploadStatus2.getShouldRetry());
                this.taskQueue.offer(new UploadNextBatchTask(this.taskQueue, this.sdkCore, this.feature));
            }
        }

        private final UploadStatus consumeBatch(DatadogContext context, List<RawBatchEvent> batch, byte[] batchMeta, DataUploader uploader) {
            return uploader.upload(context, batch, batchMeta);
        }
    }
}

