/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.configuration;

import com.datadog.android.core.configuration.UploadFrequency;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0014J\u000e\u0010\u0015\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/core/internal/configuration/DataUploadConfiguration;", "", "frequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "maxBatchesPerUploadJob", "", "(Lcom/datadog/android/core/configuration/UploadFrequency;I)V", "defaultDelayMs", "", "getDefaultDelayMs$dd_sdk_android_core_release", "()J", "getFrequency$dd_sdk_android_core_release", "()Lcom/datadog/android/core/configuration/UploadFrequency;", "getMaxBatchesPerUploadJob$dd_sdk_android_core_release", "()I", "maxDelayMs", "getMaxDelayMs$dd_sdk_android_core_release", "minDelayMs", "getMinDelayMs$dd_sdk_android_core_release", "component1", "component1$dd_sdk_android_core_release", "component2", "component2$dd_sdk_android_core_release", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "dd-sdk-android-core_release"})
public final class DataUploadConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UploadFrequency frequency;
    private final int maxBatchesPerUploadJob;
    private final long minDelayMs;
    private final long maxDelayMs;
    private final long defaultDelayMs;
    public static final int MIN_DELAY_FACTOR = 1;
    public static final int MAX_DELAY_FACTOR = 10;
    public static final int DEFAULT_DELAY_FACTOR = 5;

    public DataUploadConfiguration(@NotNull UploadFrequency frequency, int maxBatchesPerUploadJob) {
        Intrinsics.checkNotNullParameter((Object)((Object)frequency), (String)"frequency");
        this.frequency = frequency;
        this.maxBatchesPerUploadJob = maxBatchesPerUploadJob;
        this.minDelayMs = 1L * this.frequency.getBaseStepMs$dd_sdk_android_core_release();
        this.maxDelayMs = (long)10 * this.frequency.getBaseStepMs$dd_sdk_android_core_release();
        this.defaultDelayMs = (long)5 * this.frequency.getBaseStepMs$dd_sdk_android_core_release();
    }

    @NotNull
    public final UploadFrequency getFrequency$dd_sdk_android_core_release() {
        return this.frequency;
    }

    public final int getMaxBatchesPerUploadJob$dd_sdk_android_core_release() {
        return this.maxBatchesPerUploadJob;
    }

    public final long getMinDelayMs$dd_sdk_android_core_release() {
        return this.minDelayMs;
    }

    public final long getMaxDelayMs$dd_sdk_android_core_release() {
        return this.maxDelayMs;
    }

    public final long getDefaultDelayMs$dd_sdk_android_core_release() {
        return this.defaultDelayMs;
    }

    @NotNull
    public final UploadFrequency component1$dd_sdk_android_core_release() {
        return this.frequency;
    }

    public final int component2$dd_sdk_android_core_release() {
        return this.maxBatchesPerUploadJob;
    }

    @NotNull
    public final DataUploadConfiguration copy(@NotNull UploadFrequency frequency, int maxBatchesPerUploadJob) {
        Intrinsics.checkNotNullParameter((Object)((Object)frequency), (String)"frequency");
        return new DataUploadConfiguration(frequency, maxBatchesPerUploadJob);
    }

    public static /* synthetic */ DataUploadConfiguration copy$default(DataUploadConfiguration dataUploadConfiguration, UploadFrequency uploadFrequency, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            uploadFrequency = dataUploadConfiguration.frequency;
        }
        if ((n2 & 2) != 0) {
            n = dataUploadConfiguration.maxBatchesPerUploadJob;
        }
        return dataUploadConfiguration.copy(uploadFrequency, n);
    }

    @NotNull
    public String toString() {
        return "DataUploadConfiguration(frequency=" + this.frequency + ", maxBatchesPerUploadJob=" + this.maxBatchesPerUploadJob + ")";
    }

    public int hashCode() {
        int result = this.frequency.hashCode();
        result = result * 31 + Integer.hashCode(this.maxBatchesPerUploadJob);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataUploadConfiguration)) {
            return false;
        }
        DataUploadConfiguration dataUploadConfiguration = (DataUploadConfiguration)other;
        if (this.frequency != dataUploadConfiguration.frequency) {
            return false;
        }
        return this.maxBatchesPerUploadJob == dataUploadConfiguration.maxBatchesPerUploadJob;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/configuration/DataUploadConfiguration$Companion;", "", "()V", "DEFAULT_DELAY_FACTOR", "", "MAX_DELAY_FACTOR", "MIN_DELAY_FACTOR", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

