/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.HashGenerator;
import com.datadog.android.core.internal.Sha256HashGenerator;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/Sha256HashGenerator;", "Lcom/datadog/android/core/internal/HashGenerator;", "()V", "generate", "", "input", "Companion", "dd-sdk-android-core_release"})
public final class Sha256HashGenerator
implements HashGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SHA_256_HASH_GENERATION_ERROR = "Cannot generate SHA-256 hash.";

    @Override
    @Nullable
    public String generate(@NotNull String input) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = input.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            messageDigest.update(byArray);
            byte[] hashBytes = messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)hashBytes, (String)"hashBytes");
            string = ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, (Function1)generate.1.INSTANCE, (int)30, null);
        }
        catch (NoSuchAlgorithmException e) {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getUnboundInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)generate.2.INSTANCE, (Throwable)e, false, null, 48, null);
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/Sha256HashGenerator$Companion;", "", "()V", "SHA_256_HASH_GENERATION_ERROR", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

