/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.configuration;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.lint.InternalApi;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/datadog/android/core/configuration/HostsSanitizer;", "", "()V", "sanitizeHosts", "", "", "hosts", "feature", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nHostsSanitizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostsSanitizer.kt\ncom/datadog/android/core/configuration/HostsSanitizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1603#2,9:100\n1855#2:109\n1856#2:111\n1612#2:112\n1#3:110\n*S KotlinDebug\n*F\n+ 1 HostsSanitizer.kt\ncom/datadog/android/core/configuration/HostsSanitizer\n*L\n34#1:100,9\n34#1:109\n34#1:111\n34#1:112\n34#1:110\n*E\n"})
public final class HostsSanitizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VALID_IP_REGEX = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    @NotNull
    private static final String VALID_DOMAIN_REGEX = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)+([A-Za-z]|[A-Za-z][A-Za-z0-9-]*[A-Za-z0-9])$";
    @NotNull
    private static final String VALID_HOSTNAME_REGEX = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)+([A-Za-z]|[A-Za-z][A-Za-z0-9-]*[A-Za-z0-9])$";
    @NotNull
    private static final String URL_REGEX = "^(http|https)://(.*)";
    @NotNull
    public static final String WARNING_USING_URL = "You are using a url \"%s\" instead of a host to setup %s tracking. You should use instead a valid host name: \"%s\"";
    @NotNull
    public static final String ERROR_MALFORMED_URL = "You are using a malformed url \"%s\" to setup %s tracking. It will be dropped. Please try using a host name instead, e.g.: \"example.com\"";
    @NotNull
    public static final String ERROR_MALFORMED_HOST_IP_ADDRESS = "You are using a malformed host or ip address \"%s\" to setup %s tracking. It will be dropped.";

    /*
     * WARNING - void declaration
     */
    @InternalApi
    @NotNull
    public final List<String> sanitizeHosts(@NotNull List<String> hosts, @NotNull String feature) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Regex validHostNameRegEx = new Regex(VALID_HOSTNAME_REGEX);
        Regex validUrlRegex = new Regex(URL_REGEX);
        Iterable $this$mapNotNull$iv = hosts;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (validUrlRegex.matches((CharSequence)it)) {
                try {
                    URL parsedUrl = new URL(it);
                    InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getUnboundInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(it, feature, parsedUrl){
                        final /* synthetic */ String $it;
                        final /* synthetic */ String $feature;
                        final /* synthetic */ URL $parsedUrl;
                        {
                            this.$it = $it;
                            this.$feature = $feature;
                            this.$parsedUrl = $parsedUrl;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string = "You are using a url \"%s\" instead of a host to setup %s tracking. You should use instead a valid host name: \"%s\"";
                            Locale locale = Locale.US;
                            Object[] objectArray = new Object[]{this.$it, this.$feature, this.$parsedUrl.getHost()};
                            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                            return string2;
                        }
                    }, null, false, null, 56, null);
                    string2 = parsedUrl.getHost();
                }
                catch (MalformedURLException e) {
                    InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getUnboundInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(it, feature){
                        final /* synthetic */ String $it;
                        final /* synthetic */ String $feature;
                        {
                            this.$it = $it;
                            this.$feature = $feature;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string = "You are using a malformed url \"%s\" to setup %s tracking. It will be dropped. Please try using a host name instead, e.g.: \"example.com\"";
                            Locale locale = Locale.US;
                            Object[] objectArray = new Object[]{this.$it, this.$feature};
                            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                            return string2;
                        }
                    }, (Throwable)e, false, null, 48, null);
                    string2 = null;
                }
                string = string2;
            } else if (validHostNameRegEx.matches((CharSequence)it)) {
                string = it;
            } else {
                string2 = it;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                if (Intrinsics.areEqual((Object)string3, (Object)"localhost")) {
                    string = it;
                } else {
                    InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getUnboundInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(it, feature){
                        final /* synthetic */ String $it;
                        final /* synthetic */ String $feature;
                        {
                            this.$it = $it;
                            this.$feature = $feature;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string = "You are using a malformed host or ip address \"%s\" to setup %s tracking. It will be dropped.";
                            Locale locale = Locale.US;
                            Object[] objectArray = new Object[]{this.$it, this.$feature};
                            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                            return string2;
                        }
                    }, null, false, null, 56, null);
                    string = null;
                }
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/configuration/HostsSanitizer$Companion;", "", "()V", "ERROR_MALFORMED_HOST_IP_ADDRESS", "", "ERROR_MALFORMED_URL", "URL_REGEX", "VALID_DOMAIN_REGEX", "VALID_HOSTNAME_REGEX", "VALID_IP_REGEX", "WARNING_USING_URL", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

