/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core;

import android.os.Build;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012#\b\u0002\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0006J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0016\u001a\u00020\u0003H\u0002R/\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/core/LogcatLogHandler;", "", "tag", "", "predicate", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "level", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getPredicate$dd_sdk_android_core_release", "()Lkotlin/jvm/functions/Function1;", "getTag$dd_sdk_android_core_release", "()Ljava/lang/String;", "canLog", "log", "", "message", "throwable", "", "resolveTag", "Companion", "dd-sdk-android-core_release"})
public final class LogcatLogHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    @NotNull
    private final Function1<Integer, Boolean> predicate;
    private static final int MAX_TAG_LENGTH = 23;

    public LogcatLogHandler(@NotNull String tag, @NotNull Function1<? super Integer, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.tag = tag;
        this.predicate = predicate;
    }

    public /* synthetic */ LogcatLogHandler(String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(string, (Function1<? super Integer, Boolean>)function1);
    }

    @NotNull
    public final String getTag$dd_sdk_android_core_release() {
        return this.tag;
    }

    @NotNull
    public final Function1<Integer, Boolean> getPredicate$dd_sdk_android_core_release() {
        return this.predicate;
    }

    public final boolean canLog(int level) {
        return (Boolean)this.predicate.invoke((Object)level);
    }

    public final void log(int level, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!((Boolean)this.predicate.invoke((Object)level)).booleanValue()) {
            return;
        }
        String tag = this.resolveTag();
        Log.println((int)level, (String)tag, (String)message);
        if (throwable != null) {
            Log.println((int)level, (String)tag, (String)Log.getStackTraceString((Throwable)throwable));
        }
    }

    private final String resolveTag() {
        String string;
        if (this.tag.length() >= 23 && Build.VERSION.SDK_INT < 24) {
            String string2 = this.tag.substring(0, 23);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = this.tag;
        }
        return string;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/LogcatLogHandler$Companion;", "", "()V", "MAX_TAG_LENGTH", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

