/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.lint;

import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/lint/InternalApiUsageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Companion", "lint"})
public final class InternalApiUsageDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)"com.datadog.android.lint.InternalApi");
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type == AnnotationUsageType.METHOD_CALL || type == AnnotationUsageType.ASSIGNMENT_RHS || type == AnnotationUsageType.CLASS_REFERENCE || super.isApplicableAnnotationUsage(type);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UFile uFile = UastUtils.getContainingUFile((UElement)element);
        String packageName = uFile != null ? uFile.getPackageName() : null;
        CharSequence charSequence = packageName;
        if (!(charSequence == null || charSequence.length() == 0) && !StringsKt.startsWith$default((String)packageName, (String)"com.datadog", (boolean)false, (int)2, null)) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)element, (Location)context.getLocation(usageInfo.getUsage()), (String)"Symbols annotated with `com.datadog.android.lint.InternalApi` shouldn't be used outside of Datadog SDK packages.", null, (int)16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(InternalApiUsageDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"DatadogInternalApiUsage", (String)"Prohibits usages of Datadog SDK internal API", (String)"Usages of classes and methods annotated with `com.datadog.android.lint.InternalApi` are prohibited", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3920, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/lint/InternalApiUsageDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

