/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.error.internal;

import android.content.Context;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.error.internal.DatadogExceptionHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/datadog/android/error/internal/CrashReportsFeature;", "Lcom/datadog/android/api/feature/Feature;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_core_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "name", "", "getName", "()Ljava/lang/String;", "originalUncaughtExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "kotlin.jvm.PlatformType", "getOriginalUncaughtExceptionHandler$dd_sdk_android_core_release", "()Ljava/lang/Thread$UncaughtExceptionHandler;", "setOriginalUncaughtExceptionHandler$dd_sdk_android_core_release", "(Ljava/lang/Thread$UncaughtExceptionHandler;)V", "onInitialize", "", "appContext", "Landroid/content/Context;", "onStop", "resetOriginalExceptionHandler", "setupExceptionHandler", "Companion", "dd-sdk-android-core_release"})
public final class CrashReportsFeature
implements Feature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final AtomicBoolean initialized;
    private Thread.UncaughtExceptionHandler originalUncaughtExceptionHandler;
    @NotNull
    private final String name;
    @NotNull
    public static final String CRASH_FEATURE_NAME = "crash";

    public CrashReportsFeature(@NotNull FeatureSdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.sdkCore = sdkCore;
        this.initialized = new AtomicBoolean(false);
        this.originalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.name = CRASH_FEATURE_NAME;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_core_release() {
        return this.initialized;
    }

    public final Thread.UncaughtExceptionHandler getOriginalUncaughtExceptionHandler$dd_sdk_android_core_release() {
        return this.originalUncaughtExceptionHandler;
    }

    public final void setOriginalUncaughtExceptionHandler$dd_sdk_android_core_release(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.originalUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void onInitialize(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.setupExceptionHandler(appContext);
        this.initialized.set(true);
    }

    @Override
    public void onStop() {
        this.resetOriginalExceptionHandler();
        this.initialized.set(false);
    }

    private final void setupExceptionHandler(Context appContext) {
        this.originalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        new DatadogExceptionHandler(this.sdkCore, appContext).register();
    }

    private final void resetOriginalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.originalUncaughtExceptionHandler);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/error/internal/CrashReportsFeature$Companion;", "", "()V", "CRASH_FEATURE_NAME", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

