/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.thread;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.configuration.BackPressureStrategy;
import com.datadog.android.core.internal.thread.DatadogThreadFactory;
import com.datadog.android.core.internal.thread.ThreadExtKt;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/core/internal/thread/LoggingScheduledThreadPoolExecutor;", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "corePoolSize", "", "executorContext", "", "logger", "Lcom/datadog/android/api/InternalLogger;", "backPressureStrategy", "Lcom/datadog/android/core/configuration/BackPressureStrategy;", "(ILjava/lang/String;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/configuration/BackPressureStrategy;)V", "afterExecute", "", "r", "Ljava/lang/Runnable;", "t", "", "dd-sdk-android-core_release"})
public final class LoggingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private final BackPressureStrategy backPressureStrategy;

    public LoggingScheduledThreadPoolExecutor(int corePoolSize, @NotNull String executorContext, @NotNull InternalLogger logger, @NotNull BackPressureStrategy backPressureStrategy) {
        Intrinsics.checkNotNullParameter((Object)executorContext, (String)"executorContext");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)backPressureStrategy, (String)"backPressureStrategy");
        super(corePoolSize, new DatadogThreadFactory(executorContext), (arg_0, arg_1) -> LoggingScheduledThreadPoolExecutor._init_$lambda$0(logger, executorContext, backPressureStrategy, arg_0, arg_1));
        this.logger = logger;
        this.backPressureStrategy = backPressureStrategy;
    }

    @Override
    protected void afterExecute(@Nullable Runnable r, @Nullable Throwable t) {
        super.afterExecute(r, t);
        ThreadExtKt.loggingAfterExecute(r, t, this.logger);
    }

    private static final void _init_$lambda$0(InternalLogger $logger, String $executorContext, BackPressureStrategy $backPressureStrategy, Runnable r, ThreadPoolExecutor threadPoolExecutor) {
        Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
        Intrinsics.checkNotNullParameter((Object)$executorContext, (String)"$executorContext");
        Intrinsics.checkNotNullParameter((Object)$backPressureStrategy, (String)"$backPressureStrategy");
        if (r != null) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            $logger.log(InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0<String>)((Function0)new Function0<String>(r){
                final /* synthetic */ Runnable $r;
                {
                    this.$r = $r;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Dropped scheduled item in LoggingScheduledThreadPoolExecutor queue: " + this.$r;
                }
            }), null, false, (Map<String, ? extends Object>)MapsKt.mapOf((Pair)TuplesKt.to((Object)"executor.context", (Object)$executorContext)));
            $backPressureStrategy.getOnItemDropped().invoke((Object)r);
        }
    }
}

