/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.advanced;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.DataWriter;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0017R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/ScheduledWriter;", "T", "", "Lcom/datadog/android/core/internal/persistence/DataWriter;", "delegateWriter", "executorService", "Ljava/util/concurrent/ExecutorService;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/core/internal/persistence/DataWriter;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/api/InternalLogger;)V", "getDelegateWriter$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/DataWriter;", "getExecutorService$dd_sdk_android_core_release", "()Ljava/util/concurrent/ExecutorService;", "write", "", "element", "(Ljava/lang/Object;)V", "data", "", "dd-sdk-android-core_release"})
public final class ScheduledWriter<T>
implements DataWriter<T> {
    @NotNull
    private final DataWriter<T> delegateWriter;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final InternalLogger internalLogger;

    public ScheduledWriter(@NotNull DataWriter<T> delegateWriter, @NotNull ExecutorService executorService, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(delegateWriter, (String)"delegateWriter");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.delegateWriter = delegateWriter;
        this.executorService = executorService;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final DataWriter<T> getDelegateWriter$dd_sdk_android_core_release() {
        return this.delegateWriter;
    }

    @NotNull
    public final ExecutorService getExecutorService$dd_sdk_android_core_release() {
        return this.executorService;
    }

    @Override
    @WorkerThread
    public void write(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        ConcurrencyExtKt.submitSafe(this.executorService, "Data writing", this.internalLogger, () -> ScheduledWriter.write$lambda$0(this, element));
    }

    @Override
    @WorkerThread
    public void write(@NotNull List<? extends T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        ConcurrencyExtKt.submitSafe(this.executorService, "Data writing", this.internalLogger, () -> ScheduledWriter.write$lambda$1(this, data));
    }

    private static final void write$lambda$0(ScheduledWriter this$0, Object $element) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        this$0.delegateWriter.write($element);
    }

    private static final void write$lambda$1(ScheduledWriter this$0, List $data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        this$0.delegateWriter.write($data);
    }
}

