/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0017J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/core/internal/persistence/file/PlainFileReaderWriter;", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "lockFileAndWriteData", "", "file", "Ljava/io/File;", "append", "", "data", "", "readData", "writeData", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nPlainFileReaderWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainFileReaderWriter.kt\ncom/datadog/android/core/internal/persistence/file/PlainFileReaderWriter\n+ 2 FileLockExt.kt\ncom/datadog/android/core/internal/utils/FileLockExtKt\n*L\n1#1,124:1\n15#2,4:125\n*S KotlinDebug\n*F\n+ 1 PlainFileReaderWriter.kt\ncom/datadog/android/core/internal/persistence/file/PlainFileReaderWriter\n*L\n108#1:125,4\n*E\n"})
public final class PlainFileReaderWriter
implements FileReaderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @NotNull
    public static final String ERROR_WRITE = "Unable to write data to file: %s";
    @NotNull
    public static final String ERROR_READ = "Unable to read data from file: %s";

    public PlainFileReaderWriter(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Override
    @WorkerThread
    public boolean writeData(@NotNull File file, @NotNull byte[] data, boolean append) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.lockFileAndWriteData(file, append, data);
            bl = true;
        }
        catch (IOException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to write data to file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            bl = false;
        }
        catch (SecurityException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to write data to file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    @NotNull
    public byte[] readData(@NotNull File file) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            byte[] byArray;
            if (!file.exists()) {
                objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])objectArray), (Function0)new Function0<String>(file){
                    final /* synthetic */ File $file;
                    {
                        this.$file = $file;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "Unable to read data from file: %s";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$file.getPath()};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                        return string2;
                    }
                }, null, false, null, 56, null);
                byArray = EMPTY_BYTE_ARRAY;
            } else if (file.isDirectory()) {
                objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])objectArray), (Function0)new Function0<String>(file){
                    final /* synthetic */ File $file;
                    {
                        this.$file = $file;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "Unable to read data from file: %s";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$file.getPath()};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                        return string2;
                    }
                }, null, false, null, 56, null);
                byArray = EMPTY_BYTE_ARRAY;
            } else {
                byArray = FilesKt.readBytes((File)file);
            }
            objectArray = byArray;
        }
        catch (IOException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to read data from file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            objectArray = EMPTY_BYTE_ARRAY;
        }
        catch (SecurityException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to read data from file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            objectArray = EMPTY_BYTE_ARRAY;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lockFileAndWriteData(File file, boolean append, byte[] data) throws IOException {
        Closeable closeable = new FileOutputStream(file, append);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            FileLock fileLock = outputStream.getChannel().lock();
            Intrinsics.checkNotNullExpressionValue((Object)fileLock, (String)"outputStream.channel.lock()");
            FileLock $this$use$iv = fileLock;
            boolean $i$f$use = false;
            try {
                FileLock it = $this$use$iv;
                boolean bl2 = false;
                outputStream.write(data);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.release();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/core/internal/persistence/file/PlainFileReaderWriter$Companion;", "", "()V", "EMPTY_BYTE_ARRAY", "", "ERROR_READ", "", "ERROR_WRITE", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

