/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.lint.InternalApi;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a!\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\r*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u000e\u001a)\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\r*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a&\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016*\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a \u0010\u001a\u001a\u0004\u0018\u00010\u0017*\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u001b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a@\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u00022\u0006\u0010\u001f\u001a\u0002H\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u001e0!\u00a2\u0006\u0002\b\"H\u0002\u00a2\u0006\u0002\u0010#\u001a&\u0010$\u001a\u00020%*\u00020\u00022\u0006\u0010&\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006'"}, d2={"canReadSafe", "", "Ljava/io/File;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "canWriteSafe", "deleteSafe", "existsSafe", "isDirectorySafe", "isFileSafe", "lengthSafe", "", "listFilesSafe", "", "(Ljava/io/File;Lcom/datadog/android/api/InternalLogger;)[Ljava/io/File;", "filter", "Ljava/io/FileFilter;", "(Ljava/io/File;Ljava/io/FileFilter;Lcom/datadog/android/api/InternalLogger;)[Ljava/io/File;", "mkdirsSafe", "readBytesSafe", "", "readLinesSafe", "", "", "charset", "Ljava/nio/charset/Charset;", "readTextSafe", "renameToSafe", "dest", "safeCall", "T", "default", "lambda", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/io/File;Ljava/lang/Object;Lcom/datadog/android/api/InternalLogger;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeTextSafe", "", "text", "dd-sdk-android-core_release"})
public final class FileExtKt {
    private static final <T> T safeCall(File $this$safeCall, T t, InternalLogger internalLogger, Function1<? super File, ? extends T> lambda) {
        Object object;
        try {
            object = lambda.invoke((Object)$this$safeCall);
        }
        catch (SecurityException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>($this$safeCall){
                final /* synthetic */ File $this_safeCall;
                {
                    this.$this_safeCall = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Security exception was thrown for file " + this.$this_safeCall.getPath();
                }
            }, (Throwable)e, false, null, 48, null);
            object = t;
        }
        catch (Exception e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>($this$safeCall){
                final /* synthetic */ File $this_safeCall;
                {
                    this.$this_safeCall = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unexpected exception was thrown for file " + this.$this_safeCall.getPath();
                }
            }, (Throwable)e, false, null, 48, null);
            object = t;
        }
        return (T)object;
    }

    public static final boolean canWriteSafe(@NotNull File $this$canWriteSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$canWriteSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$canWriteSafe, false, internalLogger, canWriteSafe.1.INSTANCE);
    }

    @InternalApi
    public static final boolean canReadSafe(@NotNull File $this$canReadSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$canReadSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$canReadSafe, false, internalLogger, canReadSafe.1.INSTANCE);
    }

    public static final boolean deleteSafe(@NotNull File $this$deleteSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$deleteSafe, false, internalLogger, deleteSafe.1.INSTANCE);
    }

    @InternalApi
    public static final boolean existsSafe(@NotNull File $this$existsSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$existsSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$existsSafe, false, internalLogger, existsSafe.1.INSTANCE);
    }

    public static final boolean isFileSafe(@NotNull File $this$isFileSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$isFileSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$isFileSafe, false, internalLogger, isFileSafe.1.INSTANCE);
    }

    public static final boolean isDirectorySafe(@NotNull File $this$isDirectorySafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectorySafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$isDirectorySafe, false, internalLogger, isDirectorySafe.1.INSTANCE);
    }

    @Nullable
    public static final File[] listFilesSafe(@NotNull File $this$listFilesSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$listFilesSafe, null, internalLogger, listFilesSafe.1.INSTANCE);
    }

    @Nullable
    public static final File[] listFilesSafe(@NotNull File $this$listFilesSafe, @NotNull FileFilter filter, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$listFilesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$listFilesSafe, null, internalLogger, (Function1)new Function1<File, File[]>(filter){
            final /* synthetic */ FileFilter $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @Nullable
            public final File[] invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.listFiles(this.$filter);
            }
        });
    }

    public static final long lengthSafe(@NotNull File $this$lengthSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$lengthSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return ((Number)FileExtKt.safeCall($this$lengthSafe, 0L, internalLogger, lengthSafe.1.INSTANCE)).longValue();
    }

    public static final boolean mkdirsSafe(@NotNull File $this$mkdirsSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$mkdirsSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$mkdirsSafe, false, internalLogger, mkdirsSafe.1.INSTANCE);
    }

    public static final boolean renameToSafe(@NotNull File $this$renameToSafe, @NotNull File dest, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$renameToSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.safeCall($this$renameToSafe, false, internalLogger, (Function1)new Function1<File, Boolean>(dest){
            final /* synthetic */ File $dest;
            {
                this.$dest = $dest;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return $this$safeCall.renameTo(this.$dest);
            }
        });
    }

    @InternalApi
    @Nullable
    public static final String readTextSafe(@NotNull File $this$readTextSafe, @NotNull Charset charset, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$readTextSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.existsSafe($this$readTextSafe, internalLogger) && FileExtKt.canReadSafe($this$readTextSafe, internalLogger) ? (String)FileExtKt.safeCall($this$readTextSafe, null, internalLogger, (Function1)new Function1<File, String>(charset){
            final /* synthetic */ Charset $charset;
            {
                this.$charset = $charset;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return FilesKt.readText((File)$this$safeCall, (Charset)this.$charset);
            }
        }) : null;
    }

    public static /* synthetic */ String readTextSafe$default(File file, Charset charset, InternalLogger internalLogger, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileExtKt.readTextSafe(file, charset, internalLogger);
    }

    @Nullable
    public static final byte[] readBytesSafe(@NotNull File $this$readBytesSafe, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$readBytesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.existsSafe($this$readBytesSafe, internalLogger) && FileExtKt.canReadSafe($this$readBytesSafe, internalLogger) ? (byte[])FileExtKt.safeCall($this$readBytesSafe, null, internalLogger, readBytesSafe.1.INSTANCE) : null;
    }

    @InternalApi
    @Nullable
    public static final List<String> readLinesSafe(@NotNull File $this$readLinesSafe, @NotNull Charset charset, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$readLinesSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return FileExtKt.existsSafe($this$readLinesSafe, internalLogger) && FileExtKt.canReadSafe($this$readLinesSafe, internalLogger) ? (List)FileExtKt.safeCall($this$readLinesSafe, null, internalLogger, (Function1)new Function1<File, List<? extends String>>(charset){
            final /* synthetic */ Charset $charset;
            {
                this.$charset = $charset;
                super(1);
            }

            @Nullable
            public final List<String> invoke(@NotNull File $this$safeCall) {
                Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                return FilesKt.readLines((File)$this$safeCall, (Charset)this.$charset);
            }
        }) : null;
    }

    public static /* synthetic */ List readLinesSafe$default(File file, Charset charset, InternalLogger internalLogger, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileExtKt.readLinesSafe(file, charset, internalLogger);
    }

    public static final void writeTextSafe(@NotNull File $this$writeTextSafe, @NotNull String text, @NotNull Charset charset, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTextSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        if (FileExtKt.existsSafe($this$writeTextSafe, internalLogger) && FileExtKt.canWriteSafe($this$writeTextSafe, internalLogger)) {
            FileExtKt.safeCall($this$writeTextSafe, null, internalLogger, (Function1)new Function1<File, Unit>(text, charset){
                final /* synthetic */ String $text;
                final /* synthetic */ Charset $charset;
                {
                    this.$text = $text;
                    this.$charset = $charset;
                    super(1);
                }

                public final void invoke(@NotNull File $this$safeCall) {
                    Intrinsics.checkNotNullParameter((Object)$this$safeCall, (String)"$this$safeCall");
                    FilesKt.writeText((File)$this$safeCall, (String)this.$text, (Charset)this.$charset);
                }
            });
        }
    }

    public static /* synthetic */ void writeTextSafe$default(File file, String string, Charset charset, InternalLogger internalLogger, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FileExtKt.writeTextSafe(file, string, charset, internalLogger);
    }
}

