/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.EncryptedFileReaderWriter;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.security.Encryption;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0011H\u0017R\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/datadog/android/core/internal/persistence/file/EncryptedFileReaderWriter;", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "encryption", "Lcom/datadog/android/security/Encryption;", "delegate", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/security/Encryption;Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;Lcom/datadog/android/api/InternalLogger;)V", "getDelegate$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "getEncryption$dd_sdk_android_core_release", "()Lcom/datadog/android/security/Encryption;", "readData", "", "file", "Ljava/io/File;", "writeData", "", "data", "append", "Companion", "dd-sdk-android-core_release"})
public final class EncryptedFileReaderWriter
implements FileReaderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Encryption encryption;
    @NotNull
    private final FileReaderWriter delegate;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String BAD_ENCRYPTION_RESULT_MESSAGE = "Encryption of non-empty data produced empty result, aborting write operation.";
    @NotNull
    public static final String APPEND_MODE_NOT_SUPPORTED_MESSAGE = "Append mode is not supported, use EncryptedBatchFileReaderWriter instead.";

    public EncryptedFileReaderWriter(@NotNull Encryption encryption, @NotNull FileReaderWriter delegate, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)encryption, (String)"encryption");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.encryption = encryption;
        this.delegate = delegate;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final Encryption getEncryption$dd_sdk_android_core_release() {
        return this.encryption;
    }

    @NotNull
    public final FileReaderWriter getDelegate$dd_sdk_android_core_release() {
        return this.delegate;
    }

    @Override
    @WorkerThread
    public boolean writeData(@NotNull File file, @NotNull byte[] data, boolean append) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (append) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)writeData.1.INSTANCE, null, false, null, 56, null);
            return false;
        }
        byte[] encryptedData = this.encryption.encrypt(data);
        if (!(data.length == 0) && encryptedData.length == 0) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)writeData.2.INSTANCE, null, false, null, 56, null);
            return false;
        }
        return this.delegate.writeData(file, encryptedData, append);
    }

    @Override
    @WorkerThread
    @NotNull
    public byte[] readData(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.encryption.decrypt((byte[])this.delegate.readData(file));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/persistence/file/EncryptedFileReaderWriter$Companion;", "", "()V", "APPEND_MODE_NOT_SUPPORTED_MESSAGE", "", "BAD_ENCRYPTION_RESULT_MESSAGE", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

