/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.lifecycle;

import android.content.Context;
import androidx.work.WorkManager;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleMonitor;
import com.datadog.android.core.internal.utils.WorkManagerUtilsKt;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleCallback;", "Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleMonitor$Callback;", "appContext", "Landroid/content/Context;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/content/Context;Lcom/datadog/android/api/InternalLogger;)V", "contextWeakRef", "Ljava/lang/ref/Reference;", "getContextWeakRef$dd_sdk_android_core_release", "()Ljava/lang/ref/Reference;", "onPaused", "", "onResumed", "onStarted", "onStopped", "dd-sdk-android-core_release"})
public final class ProcessLifecycleCallback
implements ProcessLifecycleMonitor.Callback {
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final Reference<Context> contextWeakRef;

    public ProcessLifecycleCallback(@NotNull Context appContext, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
        this.contextWeakRef = new WeakReference<Context>(appContext);
    }

    @NotNull
    public final Reference<Context> getContextWeakRef$dd_sdk_android_core_release() {
        return this.contextWeakRef;
    }

    @Override
    public void onStarted() {
        block1: {
            Context context = this.contextWeakRef.get();
            if (context == null) break block1;
            Context it = context;
            boolean bl = false;
            if (WorkManager.isInitialized()) {
                WorkManagerUtilsKt.cancelUploadWorker(it, this.internalLogger);
            }
        }
    }

    @Override
    public void onResumed() {
    }

    @Override
    public void onStopped() {
        block1: {
            Context context = this.contextWeakRef.get();
            if (context == null) break block1;
            Context it = context;
            boolean bl = false;
            if (WorkManager.isInitialized()) {
                WorkManagerUtilsKt.triggerUploadWorker(it, this.internalLogger);
            }
        }
    }

    @Override
    public void onPaused() {
    }
}

