/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/core/internal/data/upload/CurlInterceptor;", "Lokhttp3/Interceptor;", "printBody", "", "output", "Lkotlin/Function1;", "", "", "(ZLkotlin/jvm/functions/Function1;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "CurlBuilder", "dd-sdk-android-core_release"})
public final class CurlInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean printBody;
    @NotNull
    private final Function1<String, Unit> output;
    @NotNull
    private static final String FORMAT_HEADER = "-H \"%1$s:%2$s\"";
    @NotNull
    private static final String FORMAT_METHOD = "-X %1$s";
    @NotNull
    private static final String FORMAT_BODY = "-d '%1$s'";
    @NotNull
    private static final String FORMAT_URL = "\"%1$s\"";
    @NotNull
    private static final String CONTENT_TYPE = "Content-Type";

    public CurlInterceptor(boolean printBody, @NotNull Function1<? super String, Unit> output) {
        Intrinsics.checkNotNullParameter(output, (String)"output");
        this.printBody = printBody;
        this.output = output;
    }

    public /* synthetic */ CurlInterceptor(boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(bl, (Function1<? super String, Unit>)function1);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request2 = chain.request();
        Request copy = request2.newBuilder().build();
        String curl = new CurlBuilder(copy, this.printBody).toCommand();
        this.output.invoke((Object)curl);
        return chain.proceed(request2);
    }

    public CurlInterceptor() {
        this(false, null, 3, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/data/upload/CurlInterceptor$Companion;", "", "()V", "CONTENT_TYPE", "", "FORMAT_BODY", "FORMAT_HEADER", "FORMAT_METHOD", "FORMAT_URL", "peekBody", "body", "Lokhttp3/RequestBody;", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String peekBody(RequestBody body) {
            Object object;
            if (body == null) {
                return null;
            }
            try {
                Buffer sink = new Buffer();
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                Charset charset2 = charset;
                body.writeTo((BufferedSink)sink);
                object = sink.readString(charset2);
            }
            catch (IOException e) {
                object = "Error while reading body: " + e;
            }
            catch (IllegalArgumentException e) {
                object = "Error while reading body: " + e;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006BQ\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u000e\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u001b\u001a\u00020\bJ\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u000f*\u00020\fH\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/core/internal/data/upload/CurlInterceptor$CurlBuilder;", "", "request", "Lokhttp3/Request;", "printBody", "", "(Lokhttp3/Request;Z)V", "url", "", "method", "contentType", "requestBody", "Lokhttp3/RequestBody;", "headers", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lokhttp3/RequestBody;Ljava/util/Map;Z)V", "getContentType", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "getMethod", "getPrintBody", "()Z", "getRequestBody", "()Lokhttp3/RequestBody;", "getUrl", "toCommand", "toParts", "dd-sdk-android-core_release"})
    @SourceDebugExtension(value={"SMAP\nCurlInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurlInterceptor.kt\ncom/datadog/android/core/internal/data/upload/CurlInterceptor$CurlBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n215#2:141\n216#2:144\n215#2,2:147\n1855#3,2:142\n1855#3:146\n1856#3:149\n1#4:145\n*S KotlinDebug\n*F\n+ 1 CurlInterceptor.kt\ncom/datadog/android/core/internal/data/upload/CurlInterceptor$CurlBuilder\n*L\n75#1:141\n75#1:144\n95#1:147,2\n76#1:142,2\n94#1:146\n94#1:149\n*E\n"})
    public static final class CurlBuilder {
        @NotNull
        private final String url;
        @NotNull
        private final String method;
        @Nullable
        private final String contentType;
        @Nullable
        private final RequestBody requestBody;
        @NotNull
        private final Map<String, List<String>> headers;
        private final boolean printBody;

        public CurlBuilder(@NotNull String url, @NotNull String method, @Nullable String contentType, @Nullable RequestBody requestBody, @NotNull Map<String, ? extends List<String>> headers, boolean printBody) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            this.url = url;
            this.method = method;
            this.contentType = contentType;
            this.requestBody = requestBody;
            this.headers = headers;
            this.printBody = printBody;
        }

        public /* synthetic */ CurlBuilder(String string, String string2, String string3, RequestBody requestBody, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                requestBody = null;
            }
            if ((n & 0x10) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, string2, string3, requestBody, map, bl);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @Nullable
        public final String getContentType() {
            return this.contentType;
        }

        @Nullable
        public final RequestBody getRequestBody() {
            return this.requestBody;
        }

        @NotNull
        public final Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public final boolean getPrintBody() {
            return this.printBody;
        }

        public CurlBuilder(@NotNull Request request2, boolean printBody) {
            RequestBody requestBody;
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            this(request2.url().toString(), request2.method(), (requestBody = request2.body()) != null && (requestBody = requestBody.contentType()) != null ? requestBody.toString() : null, request2.body(), request2.headers().toMultimap(), printBody);
        }

        @NotNull
        public final String toCommand() {
            List parts = new ArrayList();
            parts.add("curl");
            String string = CurlInterceptor.FORMAT_METHOD;
            Locale locale = Locale.US;
            Object object = new Object[1];
            String string2 = this.method;
            Locale locale2 = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string2.toUpperCase(locale2), (String)"this as java.lang.String).toUpperCase(locale)");
            String string3 = String.format(locale, string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
            parts.add(string3);
            Map<String, List<String>> $this$forEach$iv = this.headers;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                Iterable $this$forEach$iv2 = values;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String value = (String)element$iv2;
                    boolean bl2 = false;
                    String string4 = CurlInterceptor.FORMAT_HEADER;
                    Locale locale3 = Locale.US;
                    Object[] objectArray = new Object[]{key, value};
                    String string5 = String.format(locale3, string4, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(locale, this, *args)");
                    parts.add(string5);
                }
            }
            if (this.contentType != null && !this.headers.containsKey(CurlInterceptor.CONTENT_TYPE)) {
                string = CurlInterceptor.FORMAT_HEADER;
                Locale locale4 = Locale.US;
                object = new Object[]{CurlInterceptor.CONTENT_TYPE, this.contentType};
                String string6 = String.format(locale4, string, (Object[])Arrays.copyOf(object, ((Object)object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(locale, this, *args)");
                parts.add(string6);
            }
            RequestBody requestBody = this.requestBody;
            if (requestBody != null) {
                RequestBody it = requestBody;
                boolean bl = false;
                parts.addAll((Collection)this.toParts(it));
            }
            string = CurlInterceptor.FORMAT_URL;
            Locale locale5 = Locale.US;
            object = new Object[]{this.url};
            String string7 = String.format(locale5, string, (Object[])Arrays.copyOf(object, ((Object)object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(locale, this, *args)");
            parts.add(string7);
            return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> toParts(RequestBody $this$toParts) {
            List list;
            if ($this$toParts instanceof MultipartBody) {
                void var2_2;
                List requestCurlPart = new ArrayList();
                Iterable $this$forEach$iv = ((MultipartBody)$this$toParts).parts();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MultipartBody.Part it = (MultipartBody.Part)element$iv;
                    boolean bl = false;
                    Object object = it.headers();
                    if (object != null && (object = object.toMultimap()) != null) {
                        Object $this$forEach$iv2 = object;
                        boolean $i$f$forEach2 = false;
                        Iterator iterator = $this$forEach$iv2.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv2;
                            Map.Entry entry = element$iv2 = iterator.next();
                            boolean bl2 = false;
                            String key = (String)entry.getKey();
                            List value = (List)entry.getValue();
                            String string = CurlInterceptor.FORMAT_HEADER;
                            Locale locale = Locale.US;
                            Object[] objectArray = new Object[]{key, value};
                            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                            requestCurlPart.add(string2);
                        }
                    }
                    if (!this.printBody) continue;
                    String string = CurlInterceptor.FORMAT_BODY;
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{Companion.peekBody(it.body())};
                    String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
                    requestCurlPart.add(string3);
                }
                list = var2_2;
            } else if (this.printBody) {
                String string = CurlInterceptor.FORMAT_BODY;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{Companion.peekBody($this$toParts)};
                String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, this, *args)");
                list = CollectionsKt.listOf((Object)string4);
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
    }
}

