/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.semconv.network.internal;

import datadog.trace.bootstrap.otel.api.common.AttributesBuilder;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.AttributesExtractorUtil;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.network.internal.AddressAndPort;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import datadog.trace.bootstrap.otel.semconv.ClientAttributes;

public final class InternalClientAttributesExtractor<REQUEST> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final boolean capturePort;

    public InternalClientAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, boolean capturePort) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.capturePort = capturePort;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort clientAddressAndPort = this.addressAndPortExtractor.extract(request);
        if (clientAddressAndPort.address != null) {
            AttributesExtractorUtil.internalSet(attributes, ClientAttributes.CLIENT_ADDRESS, clientAddressAndPort.address);
            if (this.capturePort && clientAddressAndPort.port != null && clientAddressAndPort.port > 0) {
                AttributesExtractorUtil.internalSet(attributes, ClientAttributes.CLIENT_PORT, Long.valueOf(clientAddressAndPort.port.intValue()));
            }
        }
    }
}

