/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.rum;

import datadog.json.JsonWriter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RumInjectorConfig {
    private static final String GOV_CLOUD_SITE = "ddog-gov.com";
    private static final Map<String, String> REGIONS = new HashMap<String, String>();
    public final String applicationId;
    public final String clientToken;
    public final String site;
    @Nullable
    public final String service;
    @Nullable
    public final String env;
    public final int majorVersion;
    @Nullable
    public final String version;
    @Nullable
    public final Boolean trackUserInteractions;
    @Nullable
    public final Boolean trackResources;
    @Nullable
    public final Boolean trackLongTask;
    @Nullable
    public final PrivacyLevel defaultPrivacyLevel;
    @Nullable
    public final Float sessionSampleRate;
    @Nullable
    public final Float sessionReplaySampleRate;
    @Nullable
    public final String remoteConfigurationId;
    public final String jsonPayload;

    public RumInjectorConfig(String applicationId, String clientToken, @Nullable String site, @Nullable String service, @Nullable String env, int majorVersion, @Nullable String version, @Nullable Boolean trackUserInteractions, @Nullable Boolean trackResources, @Nullable Boolean trackLongTask, @Nullable PrivacyLevel defaultPrivacyLevel, @Nullable Float sessionSampleRate, @Nullable Float sessionReplaySampleRate, @Nullable String remoteConfigurationId) {
        if (applicationId == null || applicationId.isEmpty()) {
            throw new IllegalArgumentException("Invalid application id: " + applicationId);
        }
        this.applicationId = applicationId;
        if (clientToken == null || clientToken.isEmpty()) {
            throw new IllegalArgumentException("Invalid client token: " + clientToken);
        }
        this.clientToken = clientToken;
        if (site == null || site.isEmpty()) {
            this.site = "datadoghq.com";
        } else if (RumInjectorConfig.validateSite(site)) {
            this.site = site;
        } else {
            throw new IllegalArgumentException("Invalid site: " + site);
        }
        this.service = service;
        this.env = env;
        if (majorVersion != 5 && majorVersion != 6) {
            throw new IllegalArgumentException("Invalid major version: " + majorVersion);
        }
        this.majorVersion = majorVersion;
        this.version = version;
        this.trackUserInteractions = trackUserInteractions;
        this.trackResources = trackResources;
        this.trackLongTask = trackLongTask;
        if (sessionSampleRate != null && (sessionSampleRate.floatValue() < 0.0f || sessionSampleRate.floatValue() > 100.0f)) {
            throw new IllegalArgumentException("Invalid session sample rate: " + sessionSampleRate);
        }
        this.sessionSampleRate = sessionSampleRate;
        if (sessionReplaySampleRate != null && (sessionReplaySampleRate.floatValue() < 0.0f || sessionReplaySampleRate.floatValue() > 100.0f)) {
            throw new IllegalArgumentException("Invalid session replay sample rate: " + sessionReplaySampleRate);
        }
        this.sessionReplaySampleRate = sessionReplaySampleRate;
        this.defaultPrivacyLevel = defaultPrivacyLevel;
        this.remoteConfigurationId = remoteConfigurationId;
        if (this.remoteConfigurationId == null && (this.sessionSampleRate == null || this.sessionReplaySampleRate == null)) {
            throw new IllegalArgumentException("Either remote configuration id or both session and session replay sample rates must be set");
        }
        this.jsonPayload = this.jsonPayload();
    }

    private static boolean validateSite(String site) {
        for (String key : REGIONS.keySet()) {
            if (!key.equals(site)) continue;
            return true;
        }
        return false;
    }

    public String getSnippet() {
        return "<script>\n(function(h,o,u,n,d) {\n  h=h[d]=h[d]||{q:[],onReady:function(c){h.q.push(c)}}\n  d=o.createElement(u);d.async=1;d.src=n\n  n=o.getElementsByTagName(u)[0];n.parentNode.insertBefore(d,n)\n})(window,document,'script','" + this.getCdnUrl() + "','DD_RUM')\nwindow.DD_RUM.onReady(function() {\n  window.DD_RUM.init(" + this.jsonPayload + ");\n});\n</script>\n";
    }

    private String getCdnUrl() {
        if (!GOV_CLOUD_SITE.equals(this.site)) {
            return "https://www.datadoghq-browser-agent.com/datadog-rum-v" + this.majorVersion + ".js";
        }
        return "https://www.datadoghq-browser-agent.com/" + REGIONS.get(this.site) + "/v" + this.majorVersion + "/datadog-rum.js";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String jsonPayload() {
        try (JsonWriter writer = new JsonWriter();){
            writer.beginObject();
            writer.name("applicationId").value(this.applicationId);
            writer.name("clientToken").value(this.clientToken);
            if (this.site != null) {
                writer.name("site").value(this.site);
            }
            if (this.service != null) {
                writer.name("service").value(this.service);
            }
            if (this.env != null) {
                writer.name("env").value(this.env);
            }
            if (this.version != null) {
                writer.name("version").value(this.version);
            }
            if (this.trackUserInteractions != null) {
                writer.name("trackUserInteractions").value(this.trackUserInteractions);
            }
            if (this.trackResources != null) {
                writer.name("trackResources").value(this.trackResources);
            }
            if (this.trackLongTask != null) {
                writer.name("trackLongTask").value(this.trackLongTask);
            }
            if (this.defaultPrivacyLevel != null) {
                writer.name("defaultPrivacyLevel").value(this.defaultPrivacyLevel.toJson());
            }
            if (this.sessionSampleRate != null) {
                writer.name("sessionSampleRate").value(this.sessionSampleRate.floatValue());
            }
            if (this.sessionReplaySampleRate != null) {
                writer.name("sessionReplaySampleRate").value(this.sessionReplaySampleRate.floatValue());
            }
            if (this.remoteConfigurationId != null) {
                writer.name("remoteConfigurationId").value(this.remoteConfigurationId);
            }
            writer.endObject();
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to generate config payload", e);
        }
    }

    static {
        REGIONS.put("datadoghq.com", "us1");
        REGIONS.put("us3.datadoghq.com", "us3");
        REGIONS.put("us5.datadoghq.com", "us5");
        REGIONS.put("datadoghq.eu", "eu1");
        REGIONS.put("ap1.datadoghq.com", "ap1");
        REGIONS.put("ap2.datadoghq.com", "ap2");
    }

    public static enum PrivacyLevel {
        ALLOW("allow"),
        MASK("mask"),
        MASK_USER_INPUT("mask-user-input");

        private final String json;

        private PrivacyLevel(String json) {
            this.json = json;
        }

        public String toJson() {
            return this.json;
        }
    }
}

