/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.config.inversion;

import datadog.environment.EnvironmentVariables;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.telemetry.ConfigInversionMetricCollectorProvider;
import datadog.trace.config.inversion.SupportedConfigurationSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigHelper.class);
    private static final ConfigHelper INSTANCE = new ConfigHelper();
    private StrictnessPolicy configInversionStrict = StrictnessPolicy.WARNING;
    private static final String DD_PREFIX = "DD_";
    private static final String OTEL_PREFIX = "OTEL_";
    private Map<String, String> configs = Collections.emptyMap();
    private SupportedConfigurationSource configSource = new SupportedConfigurationSource();

    private ConfigHelper() {
    }

    public static ConfigHelper get() {
        return INSTANCE;
    }

    public void setConfigInversionStrict(StrictnessPolicy configInversionStrict) {
        this.configInversionStrict = configInversionStrict;
    }

    public StrictnessPolicy configInversionStrictFlag() {
        return this.configInversionStrict;
    }

    void setConfigurationSource(SupportedConfigurationSource testSource) {
        this.configSource = testSource;
    }

    void resetCache() {
        this.configs = Collections.emptyMap();
    }

    void resetToDefaults() {
        this.configSource = new SupportedConfigurationSource();
        this.configInversionStrict = StrictnessPolicy.WARNING;
        this.resetCache();
    }

    public static Map<String, String> env() {
        return ConfigHelper.get().getEnvironmentVariables();
    }

    public static String env(String key) {
        return ConfigHelper.get().getEnvironmentVariable(key);
    }

    public Map<String, String> getEnvironmentVariables() {
        if (!this.configs.isEmpty()) {
            return this.configs;
        }
        this.configs = new HashMap<String, String>();
        Map<String, String> env = EnvironmentVariables.getAll();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String primaryEnv = this.configSource.primaryEnvFromAlias(key);
            if (key.startsWith(DD_PREFIX) || key.startsWith(OTEL_PREFIX) || primaryEnv != null) {
                String envFromDeprecated;
                if (this.configSource.supported(key)) {
                    this.configs.put(key, value);
                } else if (primaryEnv != null && !this.configs.containsKey(primaryEnv)) {
                    List<String> aliases = this.configSource.getAliases(primaryEnv);
                    for (String alias : aliases) {
                        if (!env.containsKey(alias)) continue;
                        this.configs.put(primaryEnv, env.get(alias));
                        break;
                    }
                }
                if ((envFromDeprecated = this.configSource.primaryEnvFromDeprecated(key)) == null) continue;
                String warning = "Environment variable " + key + " is deprecated. Please use " + (primaryEnv != null ? primaryEnv : envFromDeprecated) + " instead.";
                log.warn(warning);
                continue;
            }
            this.configs.put(key, value);
        }
        return this.configs;
    }

    public String getEnvironmentVariable(String name) {
        List<String> aliases;
        String config;
        if (this.configs != null && this.configs.containsKey(name)) {
            return this.configs.get(name);
        }
        if ((name.startsWith(DD_PREFIX) || name.startsWith(OTEL_PREFIX)) && this.configSource.primaryEnvFromAlias(name) == null && !this.configSource.supported(name)) {
            if (this.configInversionStrict != StrictnessPolicy.TEST) {
                ConfigInversionMetricCollectorProvider.get().setUndocumentedEnvVarMetric(name);
            }
            if (this.configInversionStrict == StrictnessPolicy.STRICT) {
                return null;
            }
        }
        if ((config = EnvironmentVariables.get(name)) == null && (aliases = this.configSource.getAliases(name)) != null) {
            for (String alias : aliases) {
                String aliasValue = EnvironmentVariables.get(alias);
                if (aliasValue == null) continue;
                return aliasValue;
            }
        }
        return config;
    }

    public static enum StrictnessPolicy {
        STRICT,
        WARNING,
        TEST;

        private String displayName = this.name().toLowerCase(Locale.ROOT);

        public String toString() {
            if (this.displayName == null) {
                this.displayName = this.name().toLowerCase(Locale.ROOT);
            }
            return this.displayName;
        }
    }
}

