/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.instrumenter;

import datadog.trace.bootstrap.otel.api.trace.Span;
import datadog.trace.bootstrap.otel.api.trace.SpanContext;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextKey;
import javax.annotation.Nullable;

public final class LocalRootSpan {
    private static final ContextKey<Span> KEY = ContextKey.named("opentelemetry-traces-local-root-span");

    public static Span current() {
        return LocalRootSpan.fromContext(Context.current());
    }

    public static Span fromContext(Context context) {
        Span span = LocalRootSpan.fromContextOrNull(context);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span fromContextOrNull(Context context) {
        return context.get(KEY);
    }

    static boolean isLocalRoot(Context parentContext) {
        SpanContext spanContext = Span.fromContext(parentContext).getSpanContext();
        return !spanContext.isValid() || spanContext.isRemote();
    }

    static Context store(Context context, Span span) {
        return context.with(KEY, span);
    }

    private LocalRootSpan() {
    }
}

