/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.exceptions;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.CallDepthThreadLocalMap;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionHistogram;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionSampleEvent;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionSampler;

public interface ExceptionProfiling {
    public void start();

    public ExceptionSampleEvent process(Throwable var1);

    public boolean recordExceptionMessage();

    public static ExceptionProfiling getInstance() {
        return Holder.INSTANCE;
    }

    public static final class ExceptionProfilingImpl
    implements ExceptionProfiling {
        private final ExceptionHistogram histogram;
        private final ExceptionSampler sampler;
        private final boolean recordExceptionMessage;

        ExceptionProfilingImpl(Config config) {
            this(new ExceptionSampler(config), new ExceptionHistogram(config), config.isProfilingRecordExceptionMessage());
        }

        ExceptionProfilingImpl(ExceptionSampler sampler, ExceptionHistogram histogram, boolean recordExceptionMessage) {
            this.sampler = sampler;
            this.histogram = histogram;
            this.recordExceptionMessage = recordExceptionMessage;
        }

        @Override
        public void start() {
            this.sampler.start();
        }

        @Override
        public ExceptionSampleEvent process(Throwable t) {
            boolean firstHit = this.histogram.record(t);
            boolean sampled = this.sampler.sample();
            if (firstHit || sampled) {
                return new ExceptionSampleEvent(t, sampled, firstHit);
            }
            return null;
        }

        @Override
        public boolean recordExceptionMessage() {
            return this.recordExceptionMessage;
        }
    }

    public static final class NoOpExceptionProfiling
    implements ExceptionProfiling {
        @Override
        public void start() {
        }

        @Override
        public ExceptionSampleEvent process(Throwable t) {
            return null;
        }

        @Override
        public boolean recordExceptionMessage() {
            return false;
        }
    }

    public static final class Exclusion {
        public static void enter() {
            CallDepthThreadLocalMap.incrementCallDepth(Exclusion.class);
        }

        public static void exit() {
            CallDepthThreadLocalMap.decrementCallDepth(Exclusion.class);
        }

        public static boolean isEffective() {
            return CallDepthThreadLocalMap.getCallDepth(Exclusion.class) > 0;
        }
    }

    public static final class Holder {
        private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionProfiling.class);
        static final ExceptionProfiling INSTANCE = Holder.create();

        private static ExceptionProfiling create() {
            try {
                return new ExceptionProfilingImpl(Config.get());
            }
            catch (Throwable t) {
                LOGGER.debug("Unable to create ExceptionProfiling", t);
                return new NoOpExceptionProfiling();
            }
        }
    }
}

