/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.datastreams;

import datadog.context.Context;
import datadog.context.ContextKey;
import datadog.context.ImplicitContextKeyed;
import datadog.trace.api.datastreams.DataStreamsTags;

public class DataStreamsContext
implements ImplicitContextKeyed {
    private static final ContextKey<DataStreamsContext> CONTEXT_KEY = ContextKey.named("dsm-context-key");
    private static final DataStreamsTags CLIENT_PATHWAY_EDGE_TAGS = DataStreamsTags.create("http", DataStreamsTags.Direction.OUTBOUND);
    private static final DataStreamsTags SERVER_PATHWAY_EDGE_TAGS = DataStreamsTags.create("http", DataStreamsTags.Direction.INBOUND);
    final DataStreamsTags tags;
    final long defaultTimestamp;
    final long payloadSizeBytes;
    final boolean sendCheckpoint;

    public static DataStreamsContext fromContext(Context context) {
        return context.get(CONTEXT_KEY);
    }

    public static DataStreamsContext forHttpClient() {
        return DataStreamsContext.fromTags(CLIENT_PATHWAY_EDGE_TAGS);
    }

    public static DataStreamsContext forHttpServer() {
        return DataStreamsContext.fromTags(SERVER_PATHWAY_EDGE_TAGS);
    }

    public static DataStreamsContext fromTags(DataStreamsTags tags) {
        return new DataStreamsContext(tags, 0L, 0L, true);
    }

    public static DataStreamsContext create(DataStreamsTags tags, long defaultTimestamp, long payloadSizeBytes) {
        return new DataStreamsContext(tags, defaultTimestamp, payloadSizeBytes, true);
    }

    public static DataStreamsContext fromTagsWithoutCheckpoint(DataStreamsTags tags) {
        return new DataStreamsContext(tags, 0L, 0L, false);
    }

    private DataStreamsContext(DataStreamsTags tags, long defaultTimestamp, long payloadSizeBytes, boolean sendCheckpoint) {
        this.tags = tags;
        this.defaultTimestamp = defaultTimestamp;
        this.payloadSizeBytes = payloadSizeBytes;
        this.sendCheckpoint = sendCheckpoint;
    }

    public DataStreamsTags tags() {
        return this.tags;
    }

    public long defaultTimestamp() {
        return this.defaultTimestamp;
    }

    public long payloadSizeBytes() {
        return this.payloadSizeBytes;
    }

    public boolean sendCheckpoint() {
        return this.sendCheckpoint;
    }

    @Override
    public Context storeInto(Context context) {
        return context.with(CONTEXT_KEY, this);
    }
}

