/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.trace;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.otel.api.trace.Tracer;
import datadog.trace.bootstrap.otel.api.trace.TracerBuilder;
import datadog.trace.bootstrap.otel.api.trace.TracerProvider;
import datadog.trace.bootstrap.otel.shim.trace.OtelTracer;
import datadog.trace.bootstrap.otel.shim.trace.OtelTracerBuilder;
import datadog.trace.util.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class OtelTracerProvider
implements TracerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelTracerProvider.class);
    private static final String DEFAULT_TRACER_NAME = "";
    public static final TracerProvider INSTANCE = new OtelTracerProvider();
    private final Map<String, OtelTracer> tracers = new ConcurrentHashMap<String, OtelTracer>();

    @Override
    public Tracer get(String instrumentationScopeName) {
        return this.getTracerShim(instrumentationScopeName);
    }

    @Override
    public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.getTracerShim(instrumentationScopeName);
    }

    @Override
    public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return new OtelTracerBuilder(this, instrumentationScopeName);
    }

    OtelTracer getTracerShim(String instrumentationScopeName) {
        if (Strings.isBlank(instrumentationScopeName)) {
            LOGGER.debug("Tracer requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_TRACER_NAME;
        }
        return this.tracers.computeIfAbsent(instrumentationScopeName, OtelTracer::new);
    }
}

