/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.api.metrics.MeterBuilder;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeterProvider;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class OtelMeterBuilder
implements MeterBuilder {
    private final OtelMeterProvider meterProvider;
    private final String instrumentationScopeName;
    @Nullable
    private String instrumentationScopeVersion;
    @Nullable
    private String schemaUrl;

    OtelMeterBuilder(OtelMeterProvider meterProvider, String instrumentationScopeName) {
        this.meterProvider = meterProvider;
        this.instrumentationScopeName = instrumentationScopeName;
    }

    @Override
    public MeterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
        this.instrumentationScopeVersion = instrumentationScopeVersion;
        return this;
    }

    @Override
    public MeterBuilder setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    @Override
    public Meter build() {
        return this.meterProvider.getMeterShim(this.instrumentationScopeName, this.instrumentationScopeVersion, this.schemaUrl);
    }
}

