/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.otel.api.metrics.BatchCallback;
import datadog.trace.bootstrap.otel.api.metrics.DoubleGaugeBuilder;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.LongCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.LongUpDownCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.api.metrics.MeterProvider;
import datadog.trace.bootstrap.otel.api.metrics.ObservableMeasurement;
import datadog.trace.bootstrap.otel.shim.OtelInstrumentationScope;
import datadog.trace.bootstrap.otel.shim.metrics.OtelDoubleGauge;
import datadog.trace.bootstrap.otel.shim.metrics.OtelDoubleHistogram;
import datadog.trace.bootstrap.otel.shim.metrics.OtelLongCounter;
import datadog.trace.bootstrap.otel.shim.metrics.OtelLongUpDownCounter;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class OtelMeter
implements Meter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelMeter.class);
    private static final Pattern VALID_INSTRUMENT_NAME_PATTERN = Pattern.compile("([A-Za-z])([A-Za-z0-9_\\-./]){0,254}");
    static final Meter NOOP_METER = MeterProvider.noop().get("noop");
    static final String NOOP_INSTRUMENT_NAME = "noop";
    private final OtelInstrumentationScope instrumentationScope;

    OtelMeter(OtelInstrumentationScope instrumentationScope) {
        this.instrumentationScope = instrumentationScope;
    }

    @Override
    public LongCounterBuilder counterBuilder(String instrumentName) {
        if (!OtelMeter.validInstrumentName(instrumentName)) {
            return NOOP_METER.counterBuilder(NOOP_INSTRUMENT_NAME);
        }
        return new OtelLongCounter.Builder(this, instrumentName);
    }

    @Override
    public LongUpDownCounterBuilder upDownCounterBuilder(String instrumentName) {
        if (!OtelMeter.validInstrumentName(instrumentName)) {
            return NOOP_METER.upDownCounterBuilder(NOOP_INSTRUMENT_NAME);
        }
        return new OtelLongUpDownCounter.Builder(this, instrumentName);
    }

    @Override
    public DoubleHistogramBuilder histogramBuilder(String instrumentName) {
        if (!OtelMeter.validInstrumentName(instrumentName)) {
            return NOOP_METER.histogramBuilder(NOOP_INSTRUMENT_NAME);
        }
        return new OtelDoubleHistogram.Builder(this, instrumentName);
    }

    @Override
    public DoubleGaugeBuilder gaugeBuilder(String instrumentName) {
        if (!OtelMeter.validInstrumentName(instrumentName)) {
            return NOOP_METER.gaugeBuilder(NOOP_INSTRUMENT_NAME);
        }
        return new OtelDoubleGauge.Builder(this, instrumentName);
    }

    @Override
    public BatchCallback batchCallback(Runnable callback, ObservableMeasurement observableMeasurement, ObservableMeasurement ... additionalMeasurements) {
        return NOOP_METER.batchCallback(callback, observableMeasurement, additionalMeasurements);
    }

    public String toString() {
        return "OtelMeter{instrumentationScope=" + this.instrumentationScope + "}";
    }

    private static boolean validInstrumentName(@Nullable String instrumentName) {
        if (instrumentName != null && VALID_INSTRUMENT_NAME_PATTERN.matcher(instrumentName).matches()) {
            return true;
        }
        LOGGER.warn("Instrument name \"{}\" is invalid, returning noop instrument. Instrument names must consist of 255 or fewer characters including alphanumeric, _, ., -, /, and start with a letter.", (Object)instrumentName);
        return false;
    }
}

