/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.semconv.http;

import datadog.trace.bootstrap.otel.api.trace.StatusCode;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.SpanStatusBuilder;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.SpanStatusExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpCommonAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.semconv.http.HttpStatusCodeConverter;
import javax.annotation.Nullable;

public final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter;
    private final HttpStatusCodeConverter statusCodeConverter;

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusCodeConverter.CLIENT);
    }

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusCodeConverter.SERVER);
    }

    private HttpSpanStatusExtractor(HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter, HttpStatusCodeConverter statusCodeConverter) {
        this.getter = getter;
        this.statusCodeConverter = statusCodeConverter;
    }

    @Override
    public void extract(SpanStatusBuilder spanStatusBuilder, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Integer statusCode;
        if (response != null && (statusCode = this.getter.getHttpResponseStatusCode(request, response, error)) != null && this.statusCodeConverter.isError(statusCode)) {
            spanStatusBuilder.setStatus(StatusCode.ERROR);
            return;
        }
        SpanStatusExtractor.getDefault().extract(spanStatusBuilder, request, response, error);
    }
}

