/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.rmi;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.rmi.ContextPayload;
import java.io.IOException;
import java.io.ObjectOutput;
import java.rmi.NoSuchObjectException;
import java.rmi.server.ObjID;
import sun.rmi.transport.Connection;
import sun.rmi.transport.StreamRemoteCall;

public class ContextPropagator {
    private static final Logger log = LoggerFactory.getLogger(ContextPropagator.class);
    private static final ObjID ACTIVATOR_ID = new ObjID(1);
    private static final ObjID DGC_ID = new ObjID(2);
    private static final ObjID REGISTRY_ID = new ObjID(0);
    public static final ObjID DD_CONTEXT_CALL_ID = new ObjID("Datadog.v1.context_call".hashCode());
    private static final int CONTEXT_CHECK_CALL_OPERATION_ID = -1;
    private static final int CONTEXT_PAYLOAD_OPERATION_ID = -2;
    public static final ContextPropagator PROPAGATOR = new ContextPropagator();

    public boolean isRMIInternalObject(ObjID id) {
        return ACTIVATOR_ID.equals(id) || DGC_ID.equals(id) || REGISTRY_ID.equals(id);
    }

    public boolean isOperationWithPayload(int operationId) {
        return operationId == -2;
    }

    public void attemptToPropagateContext(ContextStore<Connection, Boolean> knownConnections, Connection c, AgentSpan span) {
        if (this.checkIfContextCanBePassed(knownConnections, c) && !this.syntheticCall(c, ContextPayload.from(span), -2)) {
            log.debug("Couldn't send context payload");
        }
    }

    private boolean checkIfContextCanBePassed(ContextStore<Connection, Boolean> knownConnections, Connection c) {
        Boolean storedResult = knownConnections.get(c);
        if (storedResult != null) {
            return storedResult;
        }
        boolean result = this.syntheticCall(c, null, -1);
        knownConnections.put(c, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean syntheticCall(Connection c, ContextPayload payload, int operationId) {
        StreamRemoteCall shareContextCall = new StreamRemoteCall(c);
        try {
            c.getOutputStream().write(80);
            ObjectOutput out = shareContextCall.getOutputStream();
            DD_CONTEXT_CALL_ID.write(out);
            out.writeInt(operationId);
            out.writeLong(operationId);
            if (payload != null) {
                payload.write(out);
            }
            try {
                shareContextCall.executeCall();
                return true;
            }
            catch (Exception e) {
                Exception ex = shareContextCall.getServerException();
                if (ex != null) {
                    if (ex instanceof NoSuchObjectException) {
                        boolean bl = false;
                        return bl;
                    }
                    log.debug("Server error when executing synthetic call", ex);
                } else {
                    log.debug("Error executing synthetic call", e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                shareContextCall.done();
            }
        }
        catch (IOException e) {
            log.debug("Communication error executing synthetic call", e);
            return false;
        }
    }
}

