/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.trace.bootstrap.debugger.CapturedContext;
import datadog.trace.bootstrap.debugger.MethodLocation;
import datadog.trace.bootstrap.debugger.ProbeId;
import datadog.trace.bootstrap.debugger.ProbeLocation;
import datadog.trace.bootstrap.debugger.el.DebuggerScript;
import java.util.List;

public interface ProbeImplementation {
    public static final ProbeImplementation UNKNOWN = new NoopProbeImplementation(new ProbeId("UNKNOWN", 0), ProbeLocation.UNKNOWN);

    public String getId();

    public ProbeId getProbeId();

    public ProbeLocation getLocation();

    public String getStrTags();

    public void evaluate(CapturedContext var1, CapturedContext.Status var2, MethodLocation var3, boolean var4);

    public void commit(CapturedContext var1, CapturedContext var2, List<CapturedContext.CapturedThrowable> var3);

    public void commit(CapturedContext var1, int var2);

    public MethodLocation getEvaluateAt();

    public CapturedContext.Status createStatus();

    public static class NoopProbeImplementation
    implements ProbeImplementation {
        private final ProbeId id;
        private final int version;
        private final ProbeLocation location;
        private final MethodLocation evaluateAt;
        private final boolean captureSnapshot;
        private final DebuggerScript<Boolean> script;
        private final String tags;

        public NoopProbeImplementation(ProbeId id, ProbeLocation location) {
            this(id, 0, location, MethodLocation.DEFAULT, true, null, null);
        }

        public NoopProbeImplementation(ProbeId id, int version, ProbeLocation location, MethodLocation evaluateAt, boolean captureSnapshot, DebuggerScript<Boolean> script, String tags) {
            this.id = id;
            this.version = version;
            this.location = location;
            this.evaluateAt = evaluateAt;
            this.captureSnapshot = captureSnapshot;
            this.script = script;
            this.tags = tags;
        }

        @Override
        public String getId() {
            return this.id.getId();
        }

        @Override
        public ProbeId getProbeId() {
            return this.id;
        }

        @Override
        public ProbeLocation getLocation() {
            return this.location;
        }

        @Override
        public String getStrTags() {
            return null;
        }

        @Override
        public void evaluate(CapturedContext context, CapturedContext.Status status, MethodLocation methodLocation, boolean singleProbe) {
        }

        @Override
        public void commit(CapturedContext entryContext, CapturedContext exitContext, List<CapturedContext.CapturedThrowable> caughtExceptions) {
        }

        @Override
        public void commit(CapturedContext lineContext, int line) {
        }

        @Override
        public MethodLocation getEvaluateAt() {
            return this.evaluateAt;
        }

        @Override
        public CapturedContext.Status createStatus() {
            return CapturedContext.Status.EMPTY_CAPTURING_STATUS;
        }
    }
}

