/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.featureflag;

import datadog.trace.api.featureflag.exposure.ExposureEvent;
import datadog.trace.api.featureflag.ufc.v1.ServerConfiguration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class FeatureFlaggingGateway {
    private static final List<ConfigListener> CONFIG_LISTENERS = new CopyOnWriteArrayList<ConfigListener>();
    private static final List<ExposureListener> EXPOSURE_LISTENERS = new CopyOnWriteArrayList<ExposureListener>();
    private static final AtomicReference<ServerConfiguration> CURRENT_CONFIG = new AtomicReference();

    private FeatureFlaggingGateway() {
    }

    public static void addConfigListener(ConfigListener listener) {
        CONFIG_LISTENERS.add(listener);
        ServerConfiguration current = CURRENT_CONFIG.get();
        if (current != null) {
            listener.accept(current);
        }
    }

    public static void removeConfigListener(ConfigListener listener) {
        CONFIG_LISTENERS.remove(listener);
    }

    public static void dispatch(ServerConfiguration config) {
        CURRENT_CONFIG.set(config);
        CONFIG_LISTENERS.forEach(listener -> listener.accept(config));
    }

    public static void addExposureListener(ExposureListener listener) {
        EXPOSURE_LISTENERS.add(listener);
    }

    public static void removeExposureListener(ExposureListener listener) {
        EXPOSURE_LISTENERS.remove(listener);
    }

    public static void dispatch(ExposureEvent event) {
        EXPOSURE_LISTENERS.forEach(listener -> listener.accept(event));
    }

    public static interface ConfigListener
    extends Consumer<ServerConfiguration> {
    }

    public static interface ExposureListener
    extends Consumer<ExposureEvent> {
    }
}

