/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigOrigin;
import datadog.trace.api.ConfigSetting;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;

public class ConfigCollector {
    private static final ConfigCollector INSTANCE = new ConfigCollector();
    private static final AtomicReferenceFieldUpdater<ConfigCollector, Map> COLLECTED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConfigCollector.class, Map.class, "collected");
    private static final Function<ConfigOrigin, Map<String, ConfigSetting>> NEW_SUB_MAP = k -> new ConcurrentHashMap();
    private volatile Map<ConfigOrigin, Map<String, ConfigSetting>> collected = new ConcurrentHashMap<ConfigOrigin, Map<String, ConfigSetting>>();

    private ConfigCollector() {
    }

    public static ConfigCollector get() {
        return INSTANCE;
    }

    public void put(String key, Object value, ConfigOrigin origin, int seqId) {
        this.put(key, value, origin, seqId, null);
    }

    public void put(String key, Object value, ConfigOrigin origin, int seqId, String configId) {
        ConfigSetting setting = ConfigSetting.of(key, value, origin, seqId, configId);
        Map<String, ConfigSetting> configMap = this.collected.computeIfAbsent(origin, NEW_SUB_MAP);
        configMap.put(key, setting);
    }

    public void putDefault(String key, Object value) {
        ConfigSetting setting = ConfigSetting.of(key, value, ConfigOrigin.DEFAULT, 1);
        Map<String, ConfigSetting> configMap = this.collected.computeIfAbsent(ConfigOrigin.DEFAULT, NEW_SUB_MAP);
        configMap.putIfAbsent(key, setting);
    }

    public void putRemote(String key, Object value) {
        this.put(key, value, ConfigOrigin.REMOTE, 0);
    }

    public void putRemote(Map<String, Object> configMap) {
        Map current;
        ConcurrentHashMap<String, ConfigSetting> merged = new ConcurrentHashMap<String, ConfigSetting>();
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            ConfigSetting setting = ConfigSetting.of(entry.getKey(), entry.getValue(), ConfigOrigin.REMOTE, 0);
            merged.put(entry.getKey(), setting);
        }
        while ((current = (Map)this.collected.putIfAbsent(ConfigOrigin.REMOTE, merged)) != null) {
            current.forEach(merged::putIfAbsent);
            if (this.collected.replace(ConfigOrigin.REMOTE, current, merged)) break;
            merged.keySet().retainAll(configMap.keySet());
        }
    }

    public Map<ConfigOrigin, Map<String, ConfigSetting>> collect() {
        if (!this.collected.isEmpty()) {
            return COLLECTED_UPDATER.getAndSet(this, new ConcurrentHashMap());
        }
        return Collections.emptyMap();
    }
}

