/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import javax.annotation.Nonnull;

public final class ConfigStrings {
    private ConfigStrings() {
    }

    public static String toEnvVar(String string) {
        return string.replace('.', '_').replace('-', '_').toUpperCase();
    }

    public static String toEnvVarLowerCase(String string) {
        return string.replace('.', '_').replace('-', '_').toLowerCase();
    }

    @Nonnull
    public static String propertyNameToEnvironmentVariableName(String setting) {
        return "DD_" + ConfigStrings.toEnvVar(setting);
    }

    @Nonnull
    public static String systemPropertyNameToEnvironmentVariableName(String setting) {
        return setting.replace('.', '_').replace('-', '_').toUpperCase();
    }

    @Nonnull
    public static String propertyNameToSystemPropertyName(String setting) {
        return "dd." + setting;
    }

    @Nonnull
    public static String normalizedHeaderTag(String str) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(str.length());
        int firstNonWhiteSpace = -1;
        int lastNonWhitespace = -1;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                builder.append('_');
                continue;
            }
            firstNonWhiteSpace = firstNonWhiteSpace == -1 ? i : firstNonWhiteSpace;
            lastNonWhitespace = i;
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '/') {
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append('_');
        }
        if (firstNonWhiteSpace == -1) {
            return "";
        }
        str = builder.substring(firstNonWhiteSpace, lastNonWhitespace + 1);
        return str;
    }

    @Nonnull
    public static String trim(String string) {
        return null == string ? "" : string.trim();
    }
}

