/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.context.Context;
import datadog.context.ContextScope;
import datadog.trace.api.Config;
import datadog.trace.api.Functions;
import datadog.trace.api.cache.QualifiedClassNameCache;
import datadog.trace.api.cache.RadixTreeCache;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.java.net.HostNameResolver;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public abstract class BaseDecorator {
    private static final QualifiedClassNameCache CLASS_NAMES = new QualifiedClassNameCache(new Function<Class<?>, CharSequence>(){

        @Override
        public String apply(Class<?> clazz) {
            String simpleName = clazz.getSimpleName();
            if (simpleName.isEmpty()) {
                String name = clazz.getName();
                int start = name.lastIndexOf(46);
                return name.substring(start + 1);
            }
            return simpleName;
        }
    }, Functions.PrefixJoin.of("."));
    protected final boolean traceAnalyticsEnabled;
    protected final Double traceAnalyticsSampleRate;

    protected BaseDecorator() {
        Config config = Config.get();
        String[] instrumentationNames = this.instrumentationNames();
        this.traceAnalyticsEnabled = instrumentationNames.length > 0 && config.isTraceAnalyticsIntegrationEnabled(this.traceAnalyticsDefault(), instrumentationNames);
        this.traceAnalyticsSampleRate = config.getInstrumentationAnalyticsSampleRate(instrumentationNames);
    }

    protected abstract String[] instrumentationNames();

    protected abstract CharSequence spanType();

    protected abstract CharSequence component();

    protected boolean traceAnalyticsDefault() {
        return false;
    }

    public AgentSpan afterStart(AgentSpan span) {
        if (this.spanType() != null) {
            span.setSpanType(this.spanType());
        }
        CharSequence component = this.component();
        span.setTag("component", component);
        span.context().setIntegrationName(component);
        if (this.traceAnalyticsEnabled) {
            span.setMetric((CharSequence)"_dd1.sr.eausr", this.traceAnalyticsSampleRate);
        }
        return span;
    }

    public ContextScope beforeFinish(ContextScope scope) {
        this.beforeFinish(scope.context());
        return scope;
    }

    public AgentSpan beforeFinish(AgentSpan span) {
        return span;
    }

    public Context beforeFinish(Context context) {
        return context;
    }

    public AgentScope onError(AgentScope scope, Throwable throwable) {
        if (scope != null) {
            this.onError(scope.span(), throwable);
        }
        return scope;
    }

    public AgentSpan onError(AgentSpan span, Throwable throwable) {
        return this.onError(span, throwable, (byte)0);
    }

    public AgentSpan onError(AgentSpan span, Throwable throwable, byte errorPriority) {
        if (throwable != null && span != null) {
            span.addThrowable(throwable instanceof ExecutionException ? throwable.getCause() : throwable, errorPriority);
        }
        return span;
    }

    public ContextScope onError(ContextScope scope, Throwable throwable) {
        if (scope != null) {
            this.onError(AgentSpan.fromContext(scope.context()), throwable);
        }
        return scope;
    }

    public AgentSpan onPeerConnection(AgentSpan span, InetSocketAddress remoteConnection) {
        if (remoteConnection != null) {
            this.onPeerConnection(span, remoteConnection.getAddress(), !remoteConnection.isUnresolved());
            this.setPeerPort(span, remoteConnection.getPort());
        }
        return span;
    }

    public AgentSpan onPeerConnection(AgentSpan span, InetAddress remoteAddress) {
        return this.onPeerConnection(span, remoteAddress, true);
    }

    public AgentSpan onPeerConnection(AgentSpan span, InetAddress remoteAddress, boolean resolved) {
        if (remoteAddress != null) {
            String ip = remoteAddress.getHostAddress();
            if (resolved && Config.get().isPeerHostNameEnabled()) {
                span.setTag("peer.hostname", HostNameResolver.hostName(remoteAddress, ip));
            }
            if (remoteAddress instanceof Inet4Address) {
                span.setTag("peer.ipv4", ip);
            } else if (remoteAddress instanceof Inet6Address) {
                span.setTag("peer.ipv6", ip);
            }
        }
        return span;
    }

    public AgentSpan setPeerPort(AgentSpan span, String port) {
        span.setTag("peer.port", port);
        return span;
    }

    public AgentSpan setPeerPort(AgentSpan span, int port) {
        if (port > 0) {
            span.setTag("peer.port", RadixTreeCache.PORTS.get(port));
        }
        return span;
    }

    public CharSequence spanNameForMethod(Method method) {
        return this.spanNameForMethod(method.getDeclaringClass(), method);
    }

    public CharSequence spanNameForMethod(Class<?> clazz, Method method) {
        if (null == method) {
            return CLASS_NAMES.getClassName(clazz);
        }
        return CLASS_NAMES.getQualifiedName(clazz, method.getName());
    }

    public CharSequence spanNameForMethod(Class<?> clazz, String methodName) {
        return CLASS_NAMES.getQualifiedName(clazz, methodName);
    }

    public CharSequence className(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        return simpleName.isEmpty() ? CLASS_NAMES.getClassName(clazz) : simpleName;
    }
}

