/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.glue;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class GlueGenerator {
    private GlueGenerator() {
    }

    public static void main(String[] args) throws ReflectiveOperationException {
        if (args.length < 3) {
            throw new IllegalArgumentException("Expected: resource-path java-path glue-name...");
        }
        Path resourcePath = Paths.get(args[0], new String[0]);
        Path javaPath = Paths.get(args[1], new String[0]);
        for (int i = 2; i < args.length; ++i) {
            Class<?> generatorClass = Class.forName("datadog.instrument.glue." + args[i] + "Generator");
            Method generateGlue = generatorClass.getMethod("generateGlue", Path.class, Path.class);
            generateGlue.invoke(null, resourcePath, javaPath);
        }
    }

    public static void classHeader(List<String> lines, String className) {
        lines.add("package datadog.instrument.glue;");
        lines.add("");
        lines.add("/** Generated by " + className + "Generator - DO NOT EDIT! */");
        lines.add("public interface " + className + " {");
    }

    public static void packBytecode(List<String> lines, byte[] bytecode) {
        if ((bytecode.length & 1) == 1) {
            throw new IllegalStateException("Bytecode length is not even; requires padding");
        }
        StringBuilder buf = new StringBuilder("      \"");
        for (int i = 0; i < bytecode.length; i += 2) {
            char c;
            if (buf.length() > 120) {
                lines.add(buf + "\"");
                buf.setLength(0);
                buf.append("          + \"");
            }
            if ((c = (char)(bytecode[i] << 8 | 0xFF & bytecode[i + 1])) <= '\u00ff') {
                buf.append(String.format("\\%03o", c));
                continue;
            }
            buf.append(String.format("\\u%04x", c));
        }
        lines.add(buf + "\";");
    }
}

