/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.exceptions;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.jfr.JfrHelper;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionCountEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;

public class ExceptionHistogram {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHistogram.class);
    static final String CLIPPED_ENTRY_TYPE_NAME = "TOO-MANY-EXCEPTIONS";
    private final Map<String, AtomicLong> histogram = new ConcurrentHashMap<String, AtomicLong>();
    private final int maxTopItems;
    private final int maxSize;
    private final EventType exceptionCountEventType;
    private final Runnable eventHook;

    ExceptionHistogram(Config config) {
        this.maxTopItems = config.getProfilingExceptionHistogramTopItems();
        this.maxSize = config.getProfilingExceptionHistogramMaxCollectionSize();
        this.exceptionCountEventType = EventType.getEventType(ExceptionCountEvent.class);
        this.eventHook = this::emit;
        JfrHelper.addPeriodicEvent(ExceptionCountEvent.class, this.eventHook);
    }

    void deregister() {
        FlightRecorder.removePeriodicEvent(this.eventHook);
    }

    public boolean record(Throwable exception) {
        if (exception == null) {
            return false;
        }
        return this.record(exception.getClass().getName());
    }

    private boolean record(String typeName) {
        long count;
        if (!this.exceptionCountEventType.isEnabled()) {
            return false;
        }
        if (!this.histogram.containsKey(typeName) && this.histogram.size() >= this.maxSize) {
            log.debug("Histogram is too big, skipping adding new entry: {}", (Object)typeName);
            typeName = CLIPPED_ENTRY_TYPE_NAME;
        }
        return (count = this.histogram.computeIfAbsent(typeName, k -> new AtomicLong()).getAndIncrement()) == 0L;
    }

    private void emit() {
        if (!this.exceptionCountEventType.isEnabled()) {
            return;
        }
        this.doEmit();
    }

    void doEmit() {
        Stream<Pair<String, Long>> items = this.histogram.entrySet().stream().map(e -> Pair.of((String)e.getKey(), ((AtomicLong)e.getValue()).getAndSet(0L))).filter(p -> (Long)p.getValue() != 0L).sorted((l1, l2) -> Long.compare((Long)l2.getValue(), (Long)l1.getValue()));
        if (this.maxTopItems > 0) {
            items = items.limit(this.maxTopItems);
        }
        this.emitEvents(items);
        this.histogram.entrySet().removeIf(e -> ((AtomicLong)e.getValue()).get() == 0L);
    }

    void emitEvents(Stream<Pair<String, Long>> items) {
        items.forEach(e -> this.createAndCommitEvent((String)e.getKey(), (Long)e.getValue()));
    }

    private void createAndCommitEvent(String type, long count) {
        ExceptionCountEvent event = new ExceptionCountEvent(type, count);
        if (event.shouldCommit()) {
            event.commit();
        }
    }

    static class Pair<K, V> {
        final K key;
        final V value;

        public static <K, V> Pair<K, V> of(K key, V value) {
            return new Pair<K, V>(key, value);
        }

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

