/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.TagMap;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanContext;
import datadog.trace.bootstrap.instrumentation.api.ImmutableSpan;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import java.util.Map;

class ExtractedSpan
extends ImmutableSpan {
    private final AgentSpanContext spanContext;

    ExtractedSpan(AgentSpanContext spanContext) {
        this.spanContext = spanContext;
    }

    @Override
    public DDTraceId getTraceId() {
        return this.spanContext.getTraceId();
    }

    @Override
    public long getSpanId() {
        return this.spanContext.getSpanId();
    }

    @Override
    public AgentSpan getRootSpan() {
        return this;
    }

    @Override
    public AgentSpan getLocalRootSpan() {
        return this;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public short getHttpStatusCode() {
        return 0;
    }

    @Override
    public CharSequence getSpanName() {
        return "";
    }

    @Override
    public boolean hasResourceName() {
        return false;
    }

    @Override
    public byte getResourceNamePriority() {
        return 127;
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public long getDurationNano() {
        return 0L;
    }

    @Override
    public CharSequence getOperationName() {
        return null;
    }

    @Override
    public String getServiceName() {
        return "";
    }

    @Override
    public CharSequence getResourceName() {
        return null;
    }

    @Override
    public Integer getSamplingPriority() {
        return this.spanContext.getSamplingPriority();
    }

    @Override
    public String getSpanType() {
        return null;
    }

    @Override
    public boolean isOutbound() {
        return false;
    }

    @Override
    public Object getTag(String tag) {
        if (this.spanContext instanceof TagContext) {
            return ((TagContext)this.spanContext).getTags().getObject(tag);
        }
        return null;
    }

    @Override
    public TagMap getTags() {
        if (this.spanContext instanceof TagContext) {
            return ((TagContext)this.spanContext).getTags();
        }
        return TagMap.EMPTY;
    }

    @Override
    public String getBaggageItem(String key) {
        Iterable<Map.Entry<String, String>> baggage = this.spanContext.baggageItems();
        for (Map.Entry<String, String> stringStringEntry : baggage) {
            if (!stringStringEntry.getKey().equals(key)) continue;
            return stringStringEntry.getValue();
        }
        return null;
    }

    @Override
    public AgentSpanContext context() {
        return this.spanContext;
    }

    @Override
    public TraceConfig traceConfig() {
        return null;
    }

    @Override
    public boolean isSameTrace(AgentSpan otherSpan) {
        return null != otherSpan && this.getTraceId().equals(otherSpan.getTraceId());
    }

    @Override
    public RequestContext getRequestContext() {
        return RequestContext.Noop.INSTANCE;
    }

    @Override
    public Flow.Action.RequestBlockingAction getRequestBlockingAction() {
        return null;
    }

    public String toString() {
        return "ExtractedSpan{spanContext=" + this.spanContext + '}';
    }
}

