/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

final class ClassLoaderKey
extends WeakReference<ClassLoader> {
    static final ClassLoader BOOT_CLASS_LOADER = null;
    static final ClassLoader SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    static final int BOOT_CLASS_LOADER_KEY_ID = 0;
    static final int SYSTEM_CLASS_LOADER_KEY_ID = 1;
    private static final AtomicInteger NEXT_KEY_ID = new AtomicInteger(2);
    private static final ReferenceQueue<ClassLoader> staleKeys = new ReferenceQueue();
    private static final List<Consumer<ClassLoaderKey>> cleaners = new CopyOnWriteArrayList<Consumer<ClassLoaderKey>>();
    final int hash;
    final int keyId;

    static void registerCleaner(Consumer<ClassLoaderKey> cleaner) {
        cleaners.add(cleaner);
    }

    static void cleanStaleKeys() {
        ClassLoaderKey key;
        while ((key = (ClassLoaderKey)staleKeys.poll()) != null) {
            int size = cleaners.size();
            for (int i = 0; i < size; ++i) {
                cleaners.get(i).accept(key);
            }
        }
    }

    ClassLoaderKey(ClassLoader cl, int hash) {
        super(cl, staleKeys);
        this.hash = hash;
        this.keyId = NEXT_KEY_ID.getAndIncrement() & Integer.MAX_VALUE;
    }

    public int hashCode() {
        return this.hash;
    }

    @SuppressFBWarnings(value={"Eq"})
    public boolean equals(Object o) {
        if (o instanceof LookupKey) {
            return this.get() == ((LookupKey)o).cl;
        }
        if (o instanceof ClassLoaderKey) {
            return this.get() == ((ClassLoaderKey)o).get();
        }
        return false;
    }

    static final class LookupKey {
        final ClassLoader cl;
        final int hash;

        LookupKey(ClassLoader cl) {
            this.cl = cl;
            this.hash = System.identityHashCode(cl);
        }

        public int hashCode() {
            return this.hash;
        }

        @SuppressFBWarnings(value={"Eq"})
        public boolean equals(Object o) {
            if (o instanceof ClassLoaderKey) {
                return this.cl == ((ClassLoaderKey)o).get();
            }
            if (o instanceof LookupKey) {
                return this.cl == ((LookupKey)o).cl;
            }
            return false;
        }
    }
}

